package cc.polymorphism.assembly.instructions;

import cc.polymorphism.assembly.std.Utility;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;

import java.util.List;

public class SwitchNode implements CompilableNode {
    private final List<Integer> keys;
    private final List<BytecodeLabel> labels;
    private final BytecodeLabel defaultLabel;

    public SwitchNode(List<Integer> keys, List<BytecodeLabel> labels, BytecodeLabel defaultLabel) {
        this.keys = keys;
        this.labels = labels;
        this.defaultLabel = defaultLabel;
    }

    @Override
    public AbstractInsnNode getNode() {
        return new LookupSwitchInsnNode(defaultLabel.getLabel(), keys.stream().mapToInt(i -> i).toArray(), Utility.unwrapLabels(labels).toArray(new LabelNode[0]));
    }
}
