package cc.polymorphism.assembly.instructions;

import cc.polymorphism.assembly.WrappedType;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class NewArrayNode implements CompilableNode {
    private final WrappedType wrappedType;

    public NewArrayNode(WrappedType wrappedType) {
        this.wrappedType = wrappedType;
    }

    @Override
    public AbstractInsnNode getNode() {
        if (wrappedType.isPrimitive()) {
            return new IntInsnNode(Opcodes.NEWARRAY, wrappedType.getNewArraySort());
        } else {
            return new TypeInsnNode(Opcodes.ANEWARRAY, wrappedType.getInternalName());
        }
    }
}
