package cc.polymorphism.assembly.instructions;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;

public class JumpNode implements CompilableNode {
    private final int opcode;
    private final BytecodeLabel target;

    public JumpNode(int opcode, BytecodeLabel target) {
        this.opcode = opcode;
        this.target = target;
    }

    @Override
    public AbstractInsnNode getNode() {
        return new JumpInsnNode(opcode, target.getLabel());
    }

    public static JumpNode jumpIfZero(BytecodeLabel target) {
        return new JumpNode(Opcodes.IFEQ, target);
    }

    public static JumpNode jumpIfNotZero(BytecodeLabel target) {
        return new JumpNode(Opcodes.IFNE, target);
    }

    public static JumpNode jumpIfLessThanZero(BytecodeLabel target) {
        return new JumpNode(Opcodes.IFLT, target);
    }

    public static JumpNode jumpIfLessThanOrEqualToZero(BytecodeLabel target) {
        return new JumpNode(Opcodes.IFLE, target);
    }

    public static JumpNode jumpIfGreaterThanZero(BytecodeLabel target) {
        return new JumpNode(Opcodes.IFGT, target);
    }

    public static JumpNode jumpIfGreaterThanOrEqualToZero(BytecodeLabel target) {
        return new JumpNode(Opcodes.IFGE, target);
    }

    public static JumpNode jumpIfIntEqual(BytecodeLabel target) {
        return new JumpNode(Opcodes.IF_ICMPEQ, target);
    }

    public static JumpNode jumpIfIntNotEqual(BytecodeLabel target) {
        return new JumpNode(Opcodes.IF_ICMPNE, target);
    }

    public static JumpNode jumpIfIntLessThan(BytecodeLabel target) {
        return new JumpNode(Opcodes.IF_ICMPLT, target);
    }

    public static JumpNode jumpIfIntLessThanOrEqualToZero(BytecodeLabel target) {
        return new JumpNode(Opcodes.IF_ICMPLE, target);
    }

    public static JumpNode jumpIfIntGreaterThan(BytecodeLabel target) {
        return new JumpNode(Opcodes.IF_ICMPGT, target);
    }

    public static JumpNode jumpIfIntGreaterThanOrEqualToZero(BytecodeLabel target) {
        return new JumpNode(Opcodes.IF_ICMPGE, target);
    }

    public static JumpNode jumpIfObjectEqual(BytecodeLabel target) {
        return new JumpNode(Opcodes.IF_ACMPEQ, target);
    }

    public static JumpNode jumpIfObjectNotEqual(BytecodeLabel target) {
        return new JumpNode(Opcodes.IF_ACMPNE, target);
    }

    public static JumpNode jumpUnconditionally(BytecodeLabel target) {
        return new JumpNode(Opcodes.GOTO, target);
    }

    public static JumpNode jsr(BytecodeLabel target) {
        return new JumpNode(Opcodes.JSR, target);
    }

    public static JumpNode jumpIfNull(BytecodeLabel target) {
        return new JumpNode(Opcodes.IFNULL, target);
    }

    public static JumpNode jumpIfNotNull(BytecodeLabel target) {
        return new JumpNode(Opcodes.IFNONNULL, target);
    }
}
