package cc.polymorphism.assembly.instructions;

import cc.polymorphism.assembly.std.Utility;
import cc.polymorphism.assembly.WrappedHandle;
import cc.polymorphism.assembly.WrappedType;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;

import java.lang.reflect.Method;
import java.util.List;

public class InvokeDynamicNode implements CompilableNode {
    private final String name;
    private final List<WrappedType> parameterTypes;
    private final WrappedType returnType;
    private final WrappedHandle bootstrapMethod;
    private final List<ConstantNode> bootstrapArgs;

    public InvokeDynamicNode(String name, List<WrappedType> parameterTypes, WrappedType returnType, WrappedHandle bootstrapMethod, List<ConstantNode> bootstrapArgs) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.bootstrapMethod = bootstrapMethod;
        this.bootstrapArgs = bootstrapArgs;
    }

    @Override
    public AbstractInsnNode getNode() {
        return new InvokeDynamicInsnNode(name, Utility.unwrapMethodDescriptor(parameterTypes, returnType), bootstrapMethod.constructHandle(), Utility.unpackConstants(bootstrapArgs));
    }

    public static InvokeDynamicNode invokeDynamic(String name, List<WrappedType> parameterTypes, WrappedType returnType, WrappedHandle bootstrapMethod, List<ConstantNode> bootstrapArgs) {
        return new InvokeDynamicNode(name, parameterTypes, returnType, bootstrapMethod, bootstrapArgs);
    }

    public static InvokeDynamicNode invokeDynamic(String name, List<WrappedType> parameterTypes, WrappedType returnType, Method bootstrap, List<ConstantNode> bootstrapArgs) {
        return invokeDynamic(name, parameterTypes, returnType, WrappedHandle.getInvokeStaticHandle(bootstrap), bootstrapArgs);
    }
}
