package cc.polymorphism.assembly.instructions;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class BytecodeLabel implements CompilableNode {
    private final LabelNode label;

    public BytecodeLabel() {
        this.label = new LabelNode();
    }

    public BytecodeLabel(LabelNode label) {
        this.label = label;
    }

    @Override
    public AbstractInsnNode getNode() {
        return label;
    }

    public LabelNode getLabel() {
        return label;
    }
}
