package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.SimpleNode;

public class IRThrowExceptionExpression extends IRExpression {
    private final IRExpression exception;

    public IRThrowExceptionExpression(IRExpression exception) {
        super(WrappedType.getAbsent());
        this.exception = exception;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(exception.bake())
                .append(SimpleNode.THROW_EXCEPTION);
    }
}
