package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.expressions.IRVariable;
import cc.polymorphism.assembly.instructions.RegisterNode;

public class IRSetVariableExpression extends IRExpression {
    private final IRVariable variable;
    private final IRExpression expression;

    public IRSetVariableExpression(IRVariable variable, IRExpression expression) {
        super(WrappedType.getAbsent());
        this.variable = variable;
        this.expression = expression;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(expression.bake())
                .append(RegisterNode.storeVar(variable));
    }
}
