package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.FieldAccessNode;

import java.lang.reflect.Field;

public class IRSetFieldExpression extends IRExpression {
    private final IRExpression instance;
    private final IRExpression value;
    private final WrappedType owner;
    private final String name;

    public IRSetFieldExpression(IRExpression instance, IRExpression value, WrappedType owner, String name, WrappedType type) {
        super(type);
        this.instance = instance;
        this.value = value;
        this.owner = owner;
        this.name = name;
    }

    public IRSetFieldExpression(IRExpression instance, IRExpression value, Field field) {
        this(instance, value, WrappedType.from(field.getDeclaringClass()), field.getName(), WrappedType.from(field.getType()));
    }

    @Override
    public BytecodeBlock bake() {
        if (instance == null) {
            return new BytecodeBlock()
                    .append(value.bake())
                    .append(FieldAccessNode.putStatic(owner, name, getType()));
        } else {
            return new BytecodeBlock()
                    .append(instance.bake())
                    .append(value.bake())
                    .append(FieldAccessNode.putField(owner, name, getType()));
        }
    }
}
