package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.SimpleNode;

public class IRSetArrayElementExpression extends IRExpression {
    private final IRExpression array;
    private final IRExpression index;
    private final IRExpression value;

    public IRSetArrayElementExpression(IRExpression array, IRExpression index, IRExpression value) {
        super(WrappedType.getAbsent());
        this.array = array;
        this.index = index;
        this.value = value;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(array.bake())
                .append(index.bake())
                .append(value.bake())
                .append(SimpleNode.getArrayStoreOp(array.getType()));
    }
}
