package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.SimpleNode;
import org.objectweb.asm.Type;

public class IRReturnExpression extends IRExpression {
    private final IRExpression target;

    public IRReturnExpression(IRExpression target) {
        super(WrappedType.getAbsent());
        this.target = target;
    }

    @Override
    public BytecodeBlock bake() {
        if (target == null) {
            return new BytecodeBlock().append(SimpleNode.RETURN_VOID);
        }

        var block = new BytecodeBlock().append(target.bake());
        var type = target.getType();

        switch (type.getSort()) {
            case Type.VOID:
                block.append(SimpleNode.RETURN_VOID);
                break;
            case Type.BOOLEAN:
            case Type.CHAR:
            case Type.BYTE:
            case Type.SHORT:
            case Type.INT:
                block.append(SimpleNode.RETURN_INT);
                break;
            case Type.FLOAT:
                block.append(SimpleNode.RETURN_FLOAT);
                break;
            case Type.LONG:
                block.append(SimpleNode.RETURN_LONG);
                break;
            case Type.DOUBLE:
                block.append(SimpleNode.RETURN_DOUBLE);
                break;
            default:
                block.append(SimpleNode.RETURN_OBJECT);
        }
        return block;
    }
}
