package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.InvokeNode;
import cc.polymorphism.assembly.instructions.SimpleNode;
import cc.polymorphism.assembly.instructions.TypeNode;

import java.util.List;

public class IRNewInstanceExpression extends IRExpression {
    private final List<WrappedType> argumentTypes;
    private final List<IRExpression> arguments;

    public IRNewInstanceExpression(WrappedType type, List<WrappedType> argumentTypes, List<IRExpression> arguments) {
        super(type);
        this.argumentTypes = argumentTypes;
        this.arguments = arguments;
    }

    @Override
    public BytecodeBlock bake() {
        var block = new BytecodeBlock()
                .append(TypeNode.newInstance(getType()))
                .append(SimpleNode.DUP);
        for (var expr : arguments) {
            block.append(expr.bake());
        }
        block.append(InvokeNode.invokeConstructor(getType(), argumentTypes));
        return block;
    }
}
