package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.ConstantNode;
import cc.polymorphism.assembly.instructions.NewArrayNode;
import cc.polymorphism.assembly.instructions.SimpleNode;

public class IRNewArrayExpression extends IRExpression {
    private final IRExpression length;
    private final WrappedType type;
    private final IRExpression[] elements;

    public IRNewArrayExpression(IRExpression length, WrappedType type, IRExpression[] elements) {
        super(type);
        this.length = length;
        this.type = type;
        this.elements = elements;
    }

    @Override
    public BytecodeBlock bake() {
        BytecodeBlock block = new BytecodeBlock()
                .append(length.bake())
                .append(new NewArrayNode(type));
        for (int i = 0; i < elements.length; i++) {
            IRExpression element = elements[i];
            block.append(SimpleNode.DUP)
                    .append(ConstantNode.intConst(i))
                    .append(element.bake())
                    .append(SimpleNode.getArrayStoreOp(type));
        }
        return block;
    }
}
