package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.SimpleNode;

public class IRNegateExpression extends IRExpression {
    private final IRExpression operand;

    public IRNegateExpression(IRExpression operand) {
        super(operand.getType());
        this.operand = operand;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(operand.bake())
                .append(SimpleNode.negateOpcodeFor(operand.getType()));
    }
}
