package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedHandle;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.ConstantNode;
import cc.polymorphism.assembly.instructions.InvokeDynamicNode;

import java.util.List;

public class IRInvokeDynamicExpression extends IRExpression {
    private final String name;
    private final List<IRExpression> args;
    private final List<WrappedType> argTypes;
    private final WrappedHandle bootstrap;
    private final List<ConstantNode> bootstrapArgs;

    public IRInvokeDynamicExpression(String name, List<IRExpression> args, List<WrappedType> argTypes, WrappedType returnType, WrappedHandle bootstrap, List<ConstantNode> bootstrapArgs) {
        super(returnType);
        this.name = name;
        this.args = args;
        this.argTypes = argTypes;
        this.bootstrap = bootstrap;
        this.bootstrapArgs = bootstrapArgs;
    }

    @Override
    public BytecodeBlock bake() {
        var block = new BytecodeBlock();
        args.forEach(arg -> block.append(arg.bake()));
        block.append(InvokeDynamicNode.invokeDynamic(name, argTypes, getType(), bootstrap, bootstrapArgs));
        return block;
    }
}
