package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.std.Utility;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.InvokeNode;

import java.lang.reflect.Method;
import java.util.List;

public class IRInvocationExpression extends IRExpression {
    private final IRExpression instance;
    private final WrappedType owner;
    private final String name;
    private final List<IRExpression> args;
    private final List<WrappedType> argTypes;

    public IRInvocationExpression(IRExpression instance, WrappedType owner, String name, List<IRExpression> args, List<WrappedType> argTypes, WrappedType returnType) {
        super(returnType);
        this.instance = instance;
        this.owner = owner;
        this.name = name;
        this.args = args;
        this.argTypes = argTypes;
    }

    public IRInvocationExpression(IRExpression instance, Method method, List<IRExpression> args) {
        this(instance, WrappedType.from(method.getDeclaringClass()), method.getName(), args, Utility.wrapMethodParameters(method), WrappedType.from(method.getReturnType()));
    }

    @Override
    public BytecodeBlock bake() {
        var block = new BytecodeBlock();

        if (instance != null) {
            block.append(instance.bake());
        }

        args.forEach(arg -> block.append(arg.bake()));

        if (instance == null) {
            block.append(InvokeNode.invokeStatic(owner, name, argTypes, getType()));
        } else if (owner.isInterface()) {
            block.append(InvokeNode.invokeInterface(owner, name, argTypes, getType()));
        } else {
            block.append(InvokeNode.invokeVirtual(owner, name, argTypes, getType()));
        }

        return block;
    }
}
