package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.TypeNode;

public class IRInstanceOfExpression extends IRExpression {
    private final IRExpression instance;
    private final WrappedType type;

    public IRInstanceOfExpression(IRExpression instance, WrappedType type) {
        super(WrappedType.from(boolean.class));
        this.instance = instance;
        this.type = type;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(instance.bake())
                .append(TypeNode.instanceOf(type));
    }
}
