package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.FieldAccessNode;

import java.lang.reflect.Field;

public class IRGetFieldExpression extends IRExpression {
    private final IRExpression instance;
    private final WrappedType owner;
    private final String name;

    public IRGetFieldExpression(IRExpression instance, WrappedType owner, String name, WrappedType type) {
        super(type);
        this.instance = instance;
        this.owner = owner;
        this.name = name;
    }

    public IRGetFieldExpression(IRExpression instance, Field field) {
        this(instance, WrappedType.from(field.getDeclaringClass()), field.getName(), WrappedType.from(field.getType()));
    }

    @Override
    public BytecodeBlock bake() {
        if (instance == null) {
            return new BytecodeBlock().append(FieldAccessNode.getStatic(owner, name, getType()));
        } else {
            return new BytecodeBlock()
                    .append(instance.bake())
                    .append(FieldAccessNode.getField(owner, name, getType()));
        }
    }
}
