package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.SimpleNode;

public class IRGetArrayElementExpression extends IRExpression {
    private final IRExpression array;
    private final IRExpression index;

    public IRGetArrayElementExpression(IRExpression array, IRExpression index) {
        super(array.getType());
        this.array = array;
        this.index = index;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(array.bake())
                .append(index.bake())
                .append(SimpleNode.getArrayLoadOp(getType()));
    }
}
