package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.ConstantNode;

public class IRConstantExpression extends IRExpression {
    private final ConstantNode cst;

    public IRConstantExpression(ConstantNode cst, WrappedType type) {
        super(type);
        this.cst = cst;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock().append(cst);
    }
}
