package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.SimpleNode;

public class IRArrayLengthExpression extends IRExpression {
    private final IRExpression array;

    public IRArrayLengthExpression(IRExpression array) {
        super(WrappedType.from(int.class));
        this.array = array;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(array.bake())
                .append(SimpleNode.ARRAY_LENGTH);
    }
}
