package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.SimpleNode;

public class IRArithmeticExpression extends IRExpression {
    private final SimpleNode operation;
    private final IRExpression left;
    private final IRExpression right;

    public IRArithmeticExpression(SimpleNode operation, IRExpression left, IRExpression right) {
        super(left.getType()); // Left expression should ALWAYS be the resultant type (i.e. LSHL/LSHR/LUSHR)
        this.operation = operation;
        this.left = left;
        this.right = right;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(left.bake())
                .append(right.bake())
                .append(operation);

    }
}
