package cc.polymorphism.assembly.expressions.flow;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.SimpleNode;

public class IRSynchronizedStructure extends IRFlowStructure {
    private final IRExpression instance;
    private final BytecodeBlock body;

    public IRSynchronizedStructure(IRExpression instance, BytecodeBlock body) {
        this.instance = instance;
        this.body = body;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(instance.bake())
                .append(SimpleNode.ENTER_MONITOR)
                .append(body)
                .append(instance.bake())
                .append(SimpleNode.EXIT_MONITOR);
    }
}
