package cc.polymorphism.assembly.expressions;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.predefined.IRSetVariableExpression;
import cc.polymorphism.assembly.instructions.RegisterNode;

public class IRVariable extends IRExpression {
    private final WrappedType wrappedType;
    private final int slot;

    public IRVariable(WrappedType wrappedType, int slot) {
        super(wrappedType);
        this.wrappedType = wrappedType;
        this.slot = slot;
    }

    @Override
    public BytecodeBlock bake() {
        return new BytecodeBlock()
                .append(RegisterNode.loadVar(this));
    }

    public WrappedType getWrappedType() {
        return wrappedType;
    }

    public int getSlot() {
        return slot;
    }

    public IRExpression set(IRExpression expression) {
        return new IRSetVariableExpression(this, expression);
    }
}
