package cc.polymorphism.assembly;

import cc.polymorphism.assembly.expressions.IRVariable;

public class GenerationContext {
    private int slotOffset = 0;

    public void setSlotOffset(int slotOffset) {
        this.slotOffset = slotOffset;
    }

    public IRVariable newVariable(WrappedType type) {
        var variable = new IRVariable(type, slotOffset);
        slotOffset += type.getType().getSize();
        return variable;
    }

    public IRVariable newVariable(Class<?> clazz) {
        return newVariable(WrappedType.from(clazz));
    }
}
