package cc.polymorphism.assembly;

import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.instructions.CompilableNode;
import cc.polymorphism.assembly.instructions.SimpleNode;
import org.objectweb.asm.tree.InsnList;

import java.util.ArrayList;
import java.util.List;

public class BytecodeBlock {
    private final List<CompilableNode> nodes = new ArrayList<>();

    public BytecodeBlock append(BytecodeBlock block) {
        nodes.addAll(block.nodes);
        return this;
    }

    public BytecodeBlock append(IRExpression expression) {
        nodes.addAll(expression.bake().nodes);
        return this;
    }

    public BytecodeBlock append(CompilableNode node) {
        nodes.add(node);
        return this;
    }

    public InsnList compile() {
        var insns = new InsnList();
        nodes.forEach(node -> insns.add(node.getNode()));
        return insns;
    }

    public BytecodeBlock voidReturn() {
        nodes.add(SimpleNode.RETURN_VOID);
        return this;
    }

    public List<CompilableNode> getNodes() {
        return nodes;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }
}
