const crypto = require('crypto');
const axios = require('axios');

module.exports = (app, db, collection, encryptData, webHookURL) => {
  if (!collection) {
    throw new Error('MongoDB collection is not initialized');
  }
    app.post('/authenticate', async (req, res) => {
      const { uuid, hwid, playerName } = req.body;
  
      if (!uuid || !hwid || !playerName) {
        return res.status(400).json({ success: false, message: 'Missing required fields' });
      }
  
      try {
        const result = await collection.findOne({ uuid: uuid });
  
        let response;
        let message;
        let webhookTitle;
        let webhookDescription;
        let webhookColor;
  
        const currentTime = new Date().toLocaleString('en-GB', { timeZone: 'GMT' });
  
        if (result) {
          if (result.hwid === hwid) {
            response = { success: true, name: result.name, uuid: result.uuid, timestamp: currentTime };
  
            message = 'Valid Authentication';
            webhookTitle = "Valid Authentication";
            webhookDescription = `Player: ${playerName}\nUUID: ${uuid}\nHWID: ${hwid}\nUSER: ${result.name}`;
            webhookColor = 0x00ff00;
          } else {
            response = { success: false, message: 'HWID mismatch' };
            message = 'Invalid HWID Detected';
            webhookTitle = "Invalid HWID Detected";
            webhookDescription = `Player: ${playerName}\nUUID: ${uuid}\nHWID: ${hwid}\nUSER: ${result.name}`;
            webhookColor = 0xff0000;
          }
        } else {
          response = { success: false, message: 'UUID not found' };
          message = 'Invalid UUID Detected';
          webhookTitle = "Invalid UUID Detected";
          webhookDescription = `Player: ${playerName}\nUUID: ${uuid}`;
          webhookColor = 0xff0000;
        }
  
        const secretKey = crypto.randomBytes(32);
  
        const encryptedResponse = encryptData(JSON.stringify(response), secretKey);
  
        await axios.post(webHookURL, {
          embeds: [
            {
              title: webhookTitle,
              description: webhookDescription,
              color: webhookColor,
              timestamp: new Date(),
            }
          ]
        });
  
        res.json({
          lmfao: encryptedResponse.encryptedData,
          sigma: encryptedResponse.iv,
          skibidi: secretKey.toString('hex')
        });
  
      } catch (err) {
        console.error('Error querying MongoDB', err);
        res.status(500).json({ success: false, message: 'Internal server error' });
      }
    });
  };