package tech.atani.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import tech.atani.connections.handler.ConnectionHandler;
import tech.atani.connections.packets.PacketManager;
import tech.atani.main.Main;

import java.net.ServerSocket;

public class Server {
    private final int port;

    private Gson gson;

    private ServerSocket serverSocket;

    private ConnectionHandler connectionHandler;

    private PacketManager packetManager;

    private UserManager userManager;

    public Server(int port) {
        this.port = port;
    }

    public void start() {
        try {
            gson = new GsonBuilder().create();

            serverSocket = new ServerSocket(port);

            connectionHandler = new ConnectionHandler(this);

            packetManager = new PacketManager();

            userManager = new UserManager();

            connectionHandler.start();

            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));

            Main.getInstance().getLogger().info("running on " + port);
        } catch (Exception e) {
            Main.getInstance().getLogger().error("couldn't start server on " + port);
        }
    }

    public void stop() {
        try {
            serverSocket.close();
            connectionHandler.stopHandler();
        } catch (Exception ignore) {}
    }

    public ServerSocket getServerSocket() {
        return serverSocket;
    }

    public PacketManager getPacketManager() {
        return packetManager;
    }

    public UserManager getUserManager() {
        return userManager;
    }

    public Gson getGson() {
        return gson;
    }
}
