package tech.atani.main;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.atani.server.Server;

public class Main {

    private static Main instance;

    private Server server;

    public Logger logger;

    public static void main(String[] args) {
        instance = new Main();

        instance.logger = LoggerFactory.getLogger(instance.getClass());

        instance.server = new Server(25565);

        instance.server.start();
    }

    public static Main getInstance() {
        return instance;
    }

    public Server getServer() {
        return server;
    }

    public Logger getLogger() {
        return logger;
    }
}
