package tech.atani.entities;

import tech.atani.main.Main;

import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.security.Key;
import java.util.Scanner;

public class User {

    // Instance of the established Socket Connection
    Socket clientSocket;

    // Print-Stream of the Client to send data.
    PrintStream printStream;

    // Client Username.
    String username;

    // Current in-game Username.
    String minecraftName;

    // Current Ip-Address.
    String ip;

    // Current InputScanner.
    Scanner inputScanner;

    // AES-Encryption Key.
    Key aesKey;

    // Connection Time.
    long connectedTime;

    public User(Socket clientSocket, String userName, String minecraftName, Key aesKey, Scanner inputScanner) {
        Main.getInstance().getLogger().debug("creating new user instance");
        this.clientSocket = clientSocket;
        Main.getInstance().getLogger().debug("set ClientSocket");
        this.username = userName;
        Main.getInstance().getLogger().debug("set username (" + userName + ")");
        this.minecraftName = minecraftName;
        Main.getInstance().getLogger().debug("set Client-Rank");
        this.inputScanner = inputScanner;
        Main.getInstance().getLogger().debug("set Input-Stream");
        this.aesKey = aesKey;
        Main.getInstance().getLogger().debug("set Encryption Key");
        this.ip = clientSocket.getInetAddress().getHostAddress();
        Main.getInstance().getLogger().debug("set IP");
        connectedTime = System.currentTimeMillis();
        Main.getInstance().getLogger().debug("set connected Time");
    }

    public Socket getClientSocket() {
        return clientSocket;
    }

    @Deprecated
    public void setClientSocket(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    public PrintStream getPrintStream() throws IOException {
        return printStream != null ? printStream : setPrintStream(new PrintStream(clientSocket.getOutputStream()));
    }

    public PrintStream setPrintStream(PrintStream printStream) {
        return this.printStream = printStream;
    }

    public String getUsername() {
        return username;
    }

    @Deprecated
    public void setUsername(String username) {
        this.username = username;
    }

    public String getMinecraftName() {
        return minecraftName;
    }

    public void setMinecraftName(String minecraftName) {
        this.minecraftName = minecraftName;
    }

    public String getIp() {
        return ip;
    }

    @Deprecated
    public void setIp(String ip) {
        this.ip = ip;
    }

    public long getConnectedTime() {
        return connectedTime;
    }

    @Deprecated
    public void setConnectedTime(long connectedTime) {
        this.connectedTime = connectedTime;
    }

    public Key getAESKey() {
        return aesKey;
    }

    public Scanner getInputScanner() {
        return inputScanner;
    }
}