package tech.atani.entities;

import tech.atani.main.Main;

import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.security.Key;
import java.util.Scanner;

public class HandshakeUser {

    Socket clientSocket;

    PrintStream printStream;

    Key aesKey;

    Scanner inputScanner;

    long connectedTime;

    public HandshakeUser(Socket clientSocket, Key aesKey, Scanner inputScanner) {
        this.clientSocket = clientSocket;
        Main.getInstance().getLogger().debug("set ClientSocket");
        this.aesKey = aesKey;
        Main.getInstance().getLogger().debug("set AES-Key");
        this.inputScanner = inputScanner;
        Main.getInstance().getLogger().debug("set Input-Stream");

        connectedTime = System.currentTimeMillis();
        Main.getInstance().getLogger().debug("set connected Time");
    }

    public Socket getClientSocket() {
        return clientSocket;
    }

    @Deprecated
    public void setClientSocket(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    public PrintStream getPrintStream() throws IOException {
        return printStream != null ? printStream : setPrintStream(new PrintStream(clientSocket.getOutputStream()));
    }

    public PrintStream setPrintStream(PrintStream printStream) {
        return this.printStream = printStream;
    }

    public long getConnectedTime() {
        return connectedTime;
    }

    @Deprecated
    public void setConnectedTime(long connectedTime) {
        this.connectedTime = connectedTime;
    }

    public Key getAESKey() {
        return aesKey;
    }

    public Scanner getInputScanner() {
        return inputScanner;
    }
}