package tech.atani.connections.packets.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import tech.atani.channels.IChannel;
import tech.atani.connections.packets.Packet;
import tech.atani.entities.User;
import tech.atani.main.Main;

public class S0LoginResponsePacket extends Packet {
    public static int packetId = 0;

    public S0LoginResponsePacket(int Id) {
        super(Id);
        packetId = Id;
    }

    public S0LoginResponsePacket(boolean success) {
        super((User) null);
        Id = packetId;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("success", success);

        if (success) {
            JsonArray userListArray = new JsonArray();

            for (User user : Main.getInstance().getServer().getUserManager().getUserList()) {
                JsonObject userJsonObject = new JsonObject();
                userJsonObject.addProperty("name", user.getUsername());
                userJsonObject.addProperty("ingame", user.getMinecraftName());

                userListArray.add(userJsonObject);
            }

            jsonObject.add("users", userListArray);
        }

        JsonArray jsonArray = new JsonArray();


        jsonObject.add("channels", jsonArray);

        JsonObject serverDataObject = new JsonObject();

        jsonObject.add("server", serverDataObject);

        setContent(jsonObject);
    }
}