package tech.atani.connections.packets.client;

import tech.atani.connections.packets.Packet;
import tech.atani.entities.User;

public class C0LoginRequestPacket extends Packet {

    public static int packetId = 0;

    public C0LoginRequestPacket(int Id) {
        super(Id);
        packetId = Id;
    }

    public C0LoginRequestPacket() {
        super((User)null);
        Id = packetId;
    }

    public String getUsername() {
        if (getContent().has("username")) {
            return getContent().get("username").getAsString();
        }
        return null;
    }

    public String getHardwareId() {
        if (getContent().has("hwid")) {
            return getContent().get("hwid").getAsString();
        }

        return null;
    }

    public String getPassword() {
        if (getContent().has("password")) {
            return getContent().get("password").getAsString();
        }

        return null;
    }

    public boolean isValidFormat() {
        return (getUsername() != null && getHardwareId() != null && getPassword() != null);
    }
}