package tech.atani.connections.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import tech.atani.connections.packets.Packet;
import tech.atani.connections.packets.client.C0LoginRequestPacket;
import tech.atani.connections.packets.server.S0LoginResponsePacket;
import tech.atani.entities.HandshakeUser;
import tech.atani.entities.User;
import tech.atani.main.Main;
import tech.atani.server.Server;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Scanner;

public class LoginHandler {

    HandshakeUser user;

    Server server;

    Thread handlerThread;

    public LoginHandler(HandshakeUser user, Server server) {
        this.user = user;
        this.server = server;
    }

    public void startHandler() {
        handlerThread = new Thread(() -> {
            if (!user.getClientSocket().isConnected()) return;

            Scanner inputScanner = user.getInputScanner();

            while (inputScanner != null && inputScanner.hasNextLine() && user.getClientSocket() != null && user.getClientSocket().isConnected() && !server.getServerSocket().isClosed()) {
                Main.getInstance().getLogger().debug("running login handler");

                if (!inputScanner.hasNextLine()) {
                    Main.getInstance().getLogger().debug("No Line so disconnected.");

                    try {
                        server.getPacketManager().sendPacket(server, new PrintStream(user.getClientSocket().getOutputStream()), new S0LoginResponsePacket(false));
                    } catch (Exception ignore) {
                    }

                    try {
                        inputScanner.close();
                        user.getClientSocket().close();
                    } catch (IOException ignore) {
                    }
                }

                String content = null;
                try {
                    content = inputScanner.nextLine();

                    Main.getInstance().getLogger().debug("getting content");

                    // Parse.
                    JsonElement jsonElement = JsonParser.parseString(content);

                    if (jsonElement.isJsonObject() && jsonElement.getAsJsonObject().has("id") && jsonElement.getAsJsonObject().has("content")) {
                        Main.getInstance().getLogger().debug("valid JSON.");

                        Packet packet = server.getPacketManager().getPacket(jsonElement.getAsJsonObject(), user);
                        Main.getInstance().getLogger().debug("tried to resolve Packet.");


                        if (packet instanceof C0LoginRequestPacket c0LoginRequestPacket) {

                            Main.getInstance().getLogger().debug("got valid Login Packet.");

                            if (c0LoginRequestPacket.isValidFormat()) {
                                Main.getInstance().getLogger().debug("got valid format.");

                                if (server.getUserManager().getUserList().stream().anyMatch(user -> user != null && user.getUsername().equalsIgnoreCase(c0LoginRequestPacket.getUsername()))) {
                                    Main.getInstance().getLogger().debug("got more then on Session.");

                                    ArrayList<User> users = server.getUserManager().getUserList();

                                    for (User user : users) {
                                        if (user == null || !user.getUsername().equalsIgnoreCase(c0LoginRequestPacket.getUsername()))
                                            continue;

                                        server.getUserManager().disconnectUser(user, false);
                                        Main.getInstance().getLogger().info("disconnected User: " + user.getUsername());
                                    }

                                    server.getUserManager().setUserList(users);
                                    Main.getInstance().getLogger().debug("disconnected all other Sessions.");
                                }

                                Main.getInstance().getLogger().debug("trying to create User.");

                                User newUser = new User(user.getClientSocket(), c0LoginRequestPacket.getUsername(), "", user.getAESKey(), inputScanner);
                                newUser.setPrintStream(user.getPrintStream());
                                Main.getInstance().getLogger().debug("created user.");

                                server.getUserManager().addUser(newUser);

                                Main.getInstance().getLogger().info("user connected: " + newUser.getUsername());

                                server.getPacketManager().sendPacket(server, newUser, new S0LoginResponsePacket(true));
                                Main.getInstance().getLogger().debug("send login success Packet.");
                            } else {
                                Main.getInstance().getLogger().info("user connection failed: " + c0LoginRequestPacket.getUsername() + " (INVALID FORMAT)");
                                try {
                                    server.getPacketManager().sendPacket(server, user, new S0LoginResponsePacket(false));
                                } catch (Exception ignore) {
                                }

                                try {
                                    inputScanner.close();
                                    user.getClientSocket().close();
                                    break;
                                } catch (Exception ignore) {
                                }
                            }
                        } else {
                            Main.getInstance().getLogger().info("received wrong Packet on connection! (" + user.getClientSocket().getInetAddress().getHostAddress() + ")");

                            try {
                                server.getPacketManager().sendPacket(server, user, new S0LoginResponsePacket(false));
                            } catch (Exception ignore) {
                            }

                            try {
                                inputScanner.close();
                                user.getClientSocket().close();
                                break;
                            } catch (IOException ignore) {
                            }
                        }
                    } else {
                        Main.getInstance().getLogger().info("received invalid Json! (" + user.getClientSocket().getInetAddress().getHostAddress() + ")\nCotent:\n" + content);
                        // Notify User.
                        try {
                            server.getPacketManager().sendPacket(server, user, new S0LoginResponsePacket(false));
                        } catch (Exception ignore) {
                        }

                        try {
                            inputScanner.close();
                            user.getClientSocket().close();
                            break;
                        } catch (IOException ignore) {
                        }
                    }
                } catch (Exception exception) {
                    if (exception instanceof IllegalStateException) {
                        Main.getInstance().getLogger().error("Couldn't handle connection! (" + user.getClientSocket().getInetAddress().getHostAddress() + ", INPUT CLOSED)");
                    } else if (exception instanceof JsonSyntaxException) {
                        Main.getInstance().getLogger().error("Couldn't handle connection! (" + user.getClientSocket().getInetAddress().getHostAddress() + ", NO JSON)\nContent:\n" + (content != null ? content : "NULL"));
                    } else {
                        Main.getInstance().getLogger().error("Couldn't handle connection!(" + user.getClientSocket().getInetAddress().getHostAddress() + ")\nContent:\n" + (content != null ? content : "NULL"), exception);
                    }

                    // Notify User.
                    try {
                        server.getPacketManager().sendPacket(server, user, new S0LoginResponsePacket(false));
                    } catch (Exception ignore) {
                    }

                    try {
                        inputScanner.close();
                        user.getClientSocket().close();
                        break;
                    } catch (IOException ignore) {
                    }
                }
            }

            Main.getInstance().getLogger().warn("Connection Handler Thread stopped!");

            stopHandler();
        });

        handlerThread.start();
    }

    public void stopHandler() {
        handlerThread.interrupt();
    }
}

