/*
 * Decompiled with CFR 0.152.
 */
package io.github.wonderlandcentral.util.interfaces;

import org.bukkit.entity.Player;

public interface IMinecraft {
    default public void send(Player player, ChatMessageType type, boolean prefix, String message, Object ... args) {
        if (player != null) {
            for (Object arg : args) {
                String replacement = "\u00a7e" + (arg == null ? "null" : arg.toString()) + "\u00a7r";
                message = message.replaceFirst("\\{\\}", replacement);
            }
            if (prefix) {
                message = type.prefix + message;
            }
            player.sendRawMessage(message);
        }
    }

    default public void error(Player player, String message, Object ... args) {
        this.send(player, ChatMessageType.ERROR, true, message, args);
    }

    default public void warn(Player player, String message, Object ... args) {
        this.send(player, ChatMessageType.WARNING, true, message, args);
    }

    default public void send(Player player, boolean prefix, String message, Object ... args) {
        this.send(player, ChatMessageType.INFO, prefix, message, args);
    }

    default public void send(Player player, String message, Object ... args) {
        this.send(player, true, message, args);
    }

    public static enum ChatMessageType {
        INFO("\u00a7aWL\u00a7f > "),
        ERROR("\u00a7aWL\u00a7f > \u00a7cerr :: \u00a7r"),
        WARNING("\u00a7aWL\u00a7f > \u00a7ewarn :: \u00a7r");

        public final String prefix;

        private ChatMessageType(String prefix) {
            this.prefix = prefix;
        }
    }
}

