/*
 * Decompiled with CFR 0.152.
 */
package io.github.wonderlandcentral.feature.impl.world;

import io.github.wonderlandcentral.data.FeatureData;
import io.github.wonderlandcentral.feature.AbstractFeature;
import io.github.wonderlandcentral.feature.FeatureCategory;
import io.github.wonderlandcentral.util.NBTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@FeatureData(name="Chest Stealer", category=FeatureCategory.WORLD)
public class ChestStealerFeature
extends AbstractFeature {
    private final Random random = new Random();
    private final Map<Player, Map<Chest, String>> playerChestIds = new HashMap<Player, Map<Chest, String>>();
    private final Map<Player, Map<Chest, Long>> playerChestOpenTime = new HashMap<Player, Map<Chest, Long>>();

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (!(event.getInventory().getHolder() instanceof Chest)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Chest chest = (Chest)event.getInventory().getHolder();
        String chestLootId = "CHEST_" + chest.getLocation().hashCode();
        this.playerChestIds.computeIfAbsent(player, k -> new HashMap()).put(chest, chestLootId);
        this.playerChestOpenTime.computeIfAbsent(player, k -> new HashMap()).put(chest, System.currentTimeMillis());
        if (chest.getInventory().getSize() == 0) {
            List<ItemStack> loot = this.getRandomLoot(chestLootId, 6);
            for (ItemStack item : loot) {
                chest.getInventory().addItem(new ItemStack[]{item});
            }
        }
    }

    @EventHandler
    public void onChestClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (!(event.getInventory().getHolder() instanceof Chest)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Chest chest = (Chest)event.getInventory().getHolder();
        String chestLootId = (String)this.playerChestIds.getOrDefault(player, Collections.emptyMap()).get(chest);
        if (chestLootId == null) {
            return;
        }
        for (ItemStack invItem : player.getInventory().getContents()) {
            String id;
            if (invItem == null || !chestLootId.equals(id = NBTUtil.getChestId(invItem))) continue;
            player.getInventory().remove(invItem);
        }
        Inventory chestInv = chest.getInventory();
        chestInv.clear();
        List<ItemStack> loot = this.getRandomLoot(chestLootId, 6);
        this.fillChestRandomly(chestInv, loot);
        Long openTime = (Long)this.playerChestOpenTime.getOrDefault(player, Collections.emptyMap()).get(chest);
        if (openTime != null) {
            long elapsed = System.currentTimeMillis() - openTime;
            this.send(player, "You spent {} seconds in this chest", new Object[]{(double)elapsed / 1000.0});
        }
        this.send(player, "Reset chest you just stole", new Object[0]);
        this.playerChestIds.getOrDefault(player, Collections.emptyMap()).remove(chest);
        this.playerChestOpenTime.getOrDefault(player, Collections.emptyMap()).remove(chest);
    }

    private List<ItemStack> getRandomLoot(String chestLootId, int count) {
        ArrayList<ItemStack> possible = new ArrayList<ItemStack>();
        possible.add(this.createLoot(Material.DIAMOND_SWORD, chestLootId, 1));
        possible.add(this.createLoot(Material.IRON_CHESTPLATE, chestLootId, 1));
        possible.add(this.createLoot(Material.ENDER_PEARL, chestLootId, 2));
        possible.add(this.createLoot(Material.GOLDEN_APPLE, chestLootId, 1));
        possible.add(this.createLoot(Material.BOW, chestLootId, 1));
        possible.add(this.createLoot(Material.ARROW, chestLootId, 16));
        possible.add(this.createLoot(Material.COOKED_BEEF, chestLootId, 8));
        possible.add(this.createLoot(Material.SNOW_BALL, chestLootId, 16));
        Collections.shuffle(possible, this.random);
        return possible.subList(0, Math.min(count, possible.size()));
    }

    private ItemStack createLoot(Material material, String chestLootId, int amount) {
        ItemStack item = new ItemStack(material, amount);
        return NBTUtil.setChestId(item, chestLootId);
    }

    private void fillChestRandomly(Inventory chestInv, List<ItemStack> loot) {
        int i;
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (i = 0; i < chestInv.getSize(); ++i) {
            if (chestInv.getItem(i) != null) continue;
            emptySlots.add(i);
        }
        Collections.shuffle(emptySlots, this.random);
        for (i = 0; i < loot.size() && i < emptySlots.size(); ++i) {
            chestInv.setItem(((Integer)emptySlots.get(i)).intValue(), loot.get(i));
        }
    }
}

