/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.world;

import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.utils.Utils;
import net.fabricmc.fabric.utils.player.InventoryUtils;
import net.fabricmc.fabric.utils.render.Render2DEngine;
import net.fabricmc.fabric.utils.render.RenderHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4538;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class WorldUtils {
    private static class_243 previousPosition = class_243.field_1353;
    private static class_243 lastVelocity = class_243.field_1353;

    public static boolean isDeadBodyNearby() {
        return ClientMain.mc.field_1687.method_18456().parallelStream().filter(e -> e != ClientMain.mc.field_1724).filter(e -> e.method_5858((class_1297)ClientMain.mc.field_1724) <= 36.0).anyMatch(class_1309::method_29504);
    }

    public static class_1297 findNearestEntity(class_1657 toPlayer, float radius, boolean seeOnly) {
        float mr = Float.MAX_VALUE;
        class_1297 entity = null;
        assert (ClientMain.mc.field_1687 != null);
        for (class_1297 e : ClientMain.mc.field_1687.method_18112()) {
            float d = e.method_5739((class_1297)toPlayer);
            if (e == toPlayer || !(d <= radius) || ClientMain.mc.field_1724.method_6057(e) != seeOnly || !(d < mr)) continue;
            mr = d;
            entity = e;
        }
        return entity;
    }

    public static class_243 predictTargetPosition(class_1657 target, float timeFactor) {
        class_243 currentPosition = target.method_19538();
        class_243 currentVelocity = currentPosition.method_1020(previousPosition);
        class_243 acceleration = currentVelocity.method_1020(lastVelocity);
        boolean isSneaking = target.method_5715();
        boolean isBlocking = target.method_6039();
        boolean isJumping = !target.method_24828();
        float movementFactor = 1.0f;
        if (isSneaking || isBlocking) {
            movementFactor *= 0.3f;
        }
        if (isJumping) {
            movementFactor *= 1.2f;
        }
        class_243 futurePosition = currentPosition.method_1019(currentVelocity.method_1021((double)(timeFactor * movementFactor)).method_1019(acceleration.method_1021(0.5 * (double)timeFactor * (double)timeFactor)));
        previousPosition = currentPosition;
        lastVelocity = currentVelocity;
        return futurePosition;
    }

    @NotNull
    public static class_243 worldToScreen(@NotNull class_243 pos) {
        class_4184 camera = ClientMain.mc.method_1561().field_4686;
        int displayHeight = ClientMain.mc.method_22683().method_4507();
        int[] viewport = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewport);
        Vector3f target = new Vector3f();
        double deltaX = pos.field_1352 - camera.method_19326().field_1352;
        double deltaY = pos.field_1351 - camera.method_19326().field_1351;
        double deltaZ = pos.field_1350 - camera.method_19326().field_1350;
        Vector4f transformedCoordinates = new Vector4f((float)deltaX, (float)deltaY, (float)deltaZ, 1.0f).mul((Matrix4fc)RenderHelper.getPositionMatrix());
        Matrix4f matrixProj = new Matrix4f((Matrix4fc)RenderHelper.getProjectionMatrix());
        Matrix4f matrixModel = new Matrix4f((Matrix4fc)RenderHelper.getModelViewMatrix());
        matrixProj.mul((Matrix4fc)matrixModel).project(transformedCoordinates.x(), transformedCoordinates.y(), transformedCoordinates.z(), viewport, target);
        return new class_243((double)target.x / ClientMain.mc.method_22683().method_4495(), (double)((float)displayHeight - target.y) / ClientMain.mc.method_22683().method_4495(), (double)target.z);
    }

    public static void placeBlock(class_3965 blockHit, boolean swingHand) {
        class_1269 result = ClientMain.mc.field_1761.method_2896(ClientMain.mc.field_1724, class_1268.field_5808, blockHit);
        if (result.method_23665() && result.method_23666() && swingHand) {
            ClientMain.mc.field_1724.method_6104(class_1268.field_5808);
        }
    }

    public static Stream<class_2818> getLoadedChunks() {
        int radius = Math.max(2, ClientMain.mc.field_1690.method_38521()) + 3;
        int diameter = radius * 2 + 1;
        class_1923 center = ClientMain.mc.field_1724.method_31476();
        class_1923 min = new class_1923(center.field_9181 - radius, center.field_9180 - radius);
        class_1923 max = new class_1923(center.field_9181 + radius, center.field_9180 + radius);
        Stream<class_2818> stream = Stream.iterate(min, pos -> {
            int x = pos.field_9181;
            int z = pos.field_9180;
            if (++x > max.field_9181) {
                x = min.field_9181;
                ++z;
            }
            if (z > max.field_9180) {
                throw new IllegalStateException("Stream limit didn't work.");
            }
            return new class_1923(x, z);
        }).limit(diameter * diameter).filter(c -> ClientMain.mc.field_1687.method_8393(c.field_9181, c.field_9180)).map(c -> ClientMain.mc.field_1687.method_8497(c.field_9181, c.field_9180)).filter(Objects::nonNull);
        return stream;
    }

    public static boolean isShieldFacingAway(class_1657 player) {
        if (ClientMain.mc.field_1724 != null && player != null) {
            class_243 playerPos = ClientMain.mc.field_1724.method_19538();
            class_243 targetPos = player.method_19538();
            class_243 directionToPlayer = playerPos.method_1020(targetPos).method_1029();
            float yaw = player.method_36454();
            float pitch = player.method_36455();
            class_243 facingDirection = new class_243(-Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)), -Math.sin(Math.toRadians(pitch)), Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch))).method_1029();
            double dotProduct = facingDirection.method_1026(directionToPlayer);
            return dotProduct < 0.0;
        }
        return false;
    }

    public static boolean canHit(class_1657 player) {
        if (ClientMain.mc.field_1724 != null && player != null) {
            class_243 normalize = ClientMain.mc.field_1724.method_19538().method_1020(player.method_19538()).method_1029();
            float getYaw = player.method_36454();
            float getPitch = player.method_36455();
            return new class_243(-Math.sin(Math.toRadians(getYaw)) * Math.cos(Math.toRadians(getPitch)), -Math.sin(Math.toRadians(getPitch)), Math.cos(Math.toRadians(getYaw)) * Math.cos(Math.toRadians(getPitch))).method_1029().method_1026(normalize) < 0.0;
        }
        return false;
    }

    public static class_2338 calcTrajectory(float yaw) {
        double x = Render2DEngine.interpolate(ClientMain.mc.field_1724.field_6014, ClientMain.mc.field_1724.method_23317(), Utils.getTick());
        double y = Render2DEngine.interpolate(ClientMain.mc.field_1724.field_6036, ClientMain.mc.field_1724.method_23318(), Utils.getTick());
        double z = Render2DEngine.interpolate(ClientMain.mc.field_1724.field_5969, ClientMain.mc.field_1724.method_23321(), Utils.getTick());
        y = y + (double)ClientMain.mc.field_1724.method_18381(ClientMain.mc.field_1724.method_18376()) - 0.1000000014901161;
        double motionX = -class_3532.method_15374((float)(yaw / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(ClientMain.mc.field_1724.method_36455() / 180.0f * (float)Math.PI));
        double motionY = -class_3532.method_15374((float)(ClientMain.mc.field_1724.method_36455() / 180.0f * 3.141593f));
        double motionZ = class_3532.method_15362((float)(yaw / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(ClientMain.mc.field_1724.method_36455() / 180.0f * (float)Math.PI));
        float power = (float)ClientMain.mc.field_1724.method_6048() / 20.0f;
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            power = 1.0f;
        }
        float distance = class_3532.method_15355((float)((float)(motionX * motionX + motionY * motionY + motionZ * motionZ)));
        motionX /= (double)distance;
        motionY /= (double)distance;
        motionZ /= (double)distance;
        float pow = power * 3.0f;
        motionX *= (double)pow;
        motionY *= (double)pow;
        motionZ *= (double)pow;
        if (!ClientMain.mc.field_1724.method_24828()) {
            motionY += ClientMain.mc.field_1724.method_18798().method_10214();
        }
        for (int i = 0; i < 300; ++i) {
            class_243 lastPos = new class_243(x, y, z);
            motionX *= 0.99;
            motionY *= 0.99;
            class_243 pos = new class_243(x += motionX, y += (motionY -= (double)0.05f), z += (motionZ *= 0.99));
            for (class_1297 ent : ClientMain.mc.field_1687.method_18112()) {
                if (ent instanceof class_1667 || ent.equals((Object)ClientMain.mc.field_1724) || !ent.method_5829().method_994(new class_238(x - 0.3, y - 0.3, z - 0.3, x + 0.3, y + 0.3, z + 0.3))) continue;
                return null;
            }
            class_3965 bhr = ClientMain.mc.field_1687.method_17742(new class_3959(lastPos, pos, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)ClientMain.mc.field_1724));
            if (bhr != null && bhr.method_17783() == class_239.class_240.field_1332) {
                return bhr.method_17777();
            }
            if (y <= -65.0) break;
        }
        return null;
    }

    public static boolean isCrit(class_1657 player, class_1297 target) {
        return player.method_7261(0.5f) > 0.9f && player.field_6017 > 0.0f && !player.method_24828() && !player.method_6101() && !player.method_5869() && !player.method_6059(class_1294.field_5919) && target instanceof class_1309;
    }

    public static class_2680 getBlockState(class_2338 pos) {
        return ClientMain.mc.field_1687.method_8320(pos);
    }

    public static boolean isBlock(class_2248 block, class_2338 pos) {
        return WorldUtils.getBlockState(pos).method_26204() == block;
    }

    public static int getEntityPing(class_1657 entity) {
        if (ClientMain.mc.method_1562() == null) {
            return 0;
        }
        class_640 playerListEntry = ClientMain.mc.method_1562().method_2871(entity.method_5667());
        if (playerListEntry == null) {
            return 0;
        }
        return playerListEntry.method_2959();
    }

    public static void hitEntity(class_1297 entity, boolean swingHand) {
        ClientMain.mc.field_1761.method_2918((class_1657)ClientMain.mc.field_1724, entity);
        if (swingHand) {
            ClientMain.mc.field_1724.method_6104(class_1268.field_5808);
        }
    }

    public static boolean useItem(class_1792 item) {
        if (ClientMain.mc.field_1724 == null || ClientMain.mc.field_1687 == null) {
            return false;
        }
        if (!ClientMain.mc.field_1724.method_6047().method_31574(item)) {
            return false;
        }
        return ClientMain.mc.field_1761.method_2919((class_1657)ClientMain.mc.field_1724, class_1268.field_5808) == class_1269.field_5812;
    }

    public static boolean placeBlock(class_1792 item, class_2338 pos) {
        if (ClientMain.mc.field_1724 == null || ClientMain.mc.field_1687 == null) {
            return false;
        }
        InventoryUtils.swap(item);
        class_2680 state = ClientMain.mc.field_1687.method_8320(pos);
        if (!(state.method_26215() || state.method_26227().method_15769() || state.method_26204().method_9564().method_26184((class_4538)ClientMain.mc.field_1687, pos))) {
            return false;
        }
        class_3965 hitResult = new class_3965(new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), class_2350.field_11036, pos, false);
        return ClientMain.mc.field_1761.method_2896(ClientMain.mc.field_1724, class_1268.field_5808, hitResult) == class_1269.field_5812;
    }
}

