/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.utils.player.FindItemResult;
import net.fabricmc.fabric.utils.world.WorldUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2231;
import net.minecraft.class_2237;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2281;
import net.minecraft.class_2304;
import net.minecraft.class_2323;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2406;
import net.minecraft.class_2428;
import net.minecraft.class_243;
import net.minecraft.class_2508;
import net.minecraft.class_2533;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2879;
import net.minecraft.class_3545;
import net.minecraft.class_3708;
import net.minecraft.class_3711;
import net.minecraft.class_3713;
import net.minecraft.class_3718;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4969;

public abstract class BlockUtils {
    private static final List<class_2248> storage = Arrays.asList(class_2246.field_10181, class_2246.field_16333, class_2246.field_16334, class_2246.field_10034, class_2246.field_10380, class_2246.field_16328, class_2246.field_10200, class_2246.field_10228, class_2246.field_10312, class_2246.field_10603, class_2246.field_10199, class_2246.field_10407, class_2246.field_10063, class_2246.field_10203, class_2246.field_10600, class_2246.field_10275, class_2246.field_10051, class_2246.field_10140, class_2246.field_10320, class_2246.field_10532, class_2246.field_10268, class_2246.field_10605, class_2246.field_10373, class_2246.field_10055, class_2246.field_10068, class_2246.field_10371, class_2246.field_10443, class_2246.field_10260, class_2246.field_10327, class_2246.field_10223, class_2246.field_10485, class_2246.field_10333, class_2246.field_17350, class_2246.field_23860, class_2246.field_16332, class_2246.field_10502, class_2246.field_10525, class_2246.field_10263, class_2246.field_10395, class_2246.field_10429, class_2246.field_28108, class_2246.field_37570, class_2246.field_37571, class_2246.field_16330, class_2246.field_10560, class_2246.field_10008, class_2246.field_10465, class_2246.field_16540, class_2246.field_40277, class_2246.field_40271);
    private static final List<class_2248> ore = Arrays.asList(class_2246.field_10418, class_2246.field_29219, class_2246.field_10212, class_2246.field_29027, class_2246.field_27120, class_2246.field_29221, class_2246.field_10571, class_2246.field_29026, class_2246.field_10080, class_2246.field_29030, class_2246.field_10090, class_2246.field_29028, class_2246.field_10442, class_2246.field_29029, class_2246.field_10013, class_2246.field_29220, class_2246.field_10213, class_2246.field_23077, class_2246.field_22109);
    private static final ExecutorService executor = Executors.newFixedThreadPool(2);

    public static class_1269 interact(class_243 vec) {
        return BlockUtils.interact(vec, class_2350.field_11036);
    }

    public static void interact(class_2338 pos, class_2350 dir) {
        class_243 vec = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        BlockUtils.interact(vec, dir);
    }

    public static int getAnchorChargeLevel(class_2338 block) {
        if (ClientMain.mc.field_1687 != null && ClientMain.mc.field_1687.method_8320(block).method_26204().equals(class_2246.field_23152)) {
            class_2680 pos = ClientMain.mc.field_1687.method_8320(block);
            return (Integer)pos.method_11654((class_2769)class_4969.field_23153);
        }
        return -1;
    }

    public static class_1269 interact(class_243 vec3d, class_2350 dir) {
        class_2382 vec3i = new class_2382((int)vec3d.field_1352, (int)vec3d.field_1351, (int)vec3d.field_1350);
        class_2338 pos = new class_2338(vec3i);
        class_3965 result = new class_3965(vec3d, dir, pos, false);
        assert (ClientMain.mc.field_1761 != null);
        assert (ClientMain.mc.field_1724 != null);
        return ClientMain.mc.field_1761.method_2896(ClientMain.mc.field_1724, ClientMain.mc.field_1724.method_6058(), result);
    }

    public static boolean isBlock(class_2248 block, class_2338 pos) {
        return BlockUtils.getBlockState(pos).method_26204() == block;
    }

    public static class_2680 getBlockState(class_2338 pos) {
        return ClientMain.mc.field_1687.method_8320(pos);
    }

    public static boolean hasBlock(class_2338 pos) {
        return !ClientMain.mc.field_1687.method_8320(pos).method_26215();
    }

    public static class_1269 interact(class_3965 result) {
        return ClientMain.mc.field_1761.method_2896(ClientMain.mc.field_1724, ClientMain.mc.field_1724.method_6058(), result);
    }

    public static boolean isAnchorCharged(class_2338 anchor) {
        if (!BlockUtils.isBlock(class_2246.field_23152, anchor)) {
            return false;
        }
        try {
            return (Integer)BlockUtils.getBlockState(anchor).method_11654((class_2769)class_4969.field_23153) != 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isAnchorUncharged(class_2338 anchor) {
        try {
            if (!BlockUtils.isBlock(class_2246.field_23152, anchor)) {
                return false;
            }
            return (Integer)BlockUtils.getBlockState(anchor).method_11654((class_2769)class_4969.field_23153) == 0;
        }
        catch (IllegalArgumentException var2) {
            return false;
        }
    }

    public static boolean place(class_2338 blockPos, FindItemResult findItemResult, boolean swingHand, boolean checkEntities) {
        if (findItemResult.isOffhand()) {
            return BlockUtils.place(blockPos, class_1268.field_5810, ClientMain.mc.field_1724.method_31548().field_7545, swingHand, checkEntities);
        }
        if (findItemResult.isHotbar()) {
            return BlockUtils.place(blockPos, class_1268.field_5808, findItemResult.getSlot(), swingHand, checkEntities);
        }
        return false;
    }

    public static boolean place(class_2338 blockPos, class_1268 hand, int slot, boolean swingHand, boolean checkEntities) {
        class_2338 neighbour;
        if (slot < 0 || slot > 8) {
            return false;
        }
        class_2248 toPlace = class_2246.field_10540;
        class_1799 i = hand == class_1268.field_5808 ? ClientMain.mc.field_1724.method_31548().method_5438(slot) : ClientMain.mc.field_1724.method_31548().method_5438(class_1268.field_5810.ordinal());
        class_1792 class_17922 = i.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            toPlace = blockItem.method_7711();
        }
        if (!BlockUtils.canPlaceBlock(blockPos, checkEntities, toPlace)) {
            return false;
        }
        class_243 hitPos = class_243.method_24953((class_2382)blockPos);
        class_2350 side = BlockUtils.getPlaceSide(blockPos);
        if (side == null) {
            side = class_2350.field_11036;
            neighbour = blockPos;
        } else {
            neighbour = blockPos.method_10093(side);
            hitPos = hitPos.method_1031((double)side.method_10148() * 0.5, (double)side.method_10164() * 0.5, (double)side.method_10165() * 0.5);
        }
        class_3965 bhr = new class_3965(hitPos, side.method_10153(), neighbour, false);
        BlockUtils.interact(bhr, hand, swingHand);
        return true;
    }

    public static void interact(class_3965 blockHitResult, class_1268 hand, boolean swing) {
        boolean wasSneaking = ClientMain.mc.field_1724.field_3913.field_3903;
        ClientMain.mc.field_1724.field_3913.field_3903 = false;
        class_1269 result = ClientMain.mc.field_1761.method_2896(ClientMain.mc.field_1724, hand, blockHitResult);
        if (result.method_23666()) {
            if (swing) {
                ClientMain.mc.field_1724.method_6104(hand);
            } else {
                ClientMain.mc.method_1562().method_52787((class_2596)new class_2879(hand));
            }
        }
        ClientMain.mc.field_1724.field_3913.field_3903 = wasSneaking;
    }

    public static boolean canPlaceBlock(class_2338 blockPos, boolean checkEntities, class_2248 block) {
        if (blockPos == null) {
            return false;
        }
        if (!class_1937.method_25953((class_2338)blockPos)) {
            return false;
        }
        if (!ClientMain.mc.field_1687.method_8320(blockPos).method_45474()) {
            return false;
        }
        return !checkEntities || ClientMain.mc.field_1687.method_8628(block.method_9564(), blockPos, class_3726.method_16194());
    }

    public static class_2350 getPlaceSide(class_2338 blockPos) {
        class_243 lookVec = blockPos.method_46558().method_1020(ClientMain.mc.field_1724.method_33571());
        double bestRelevancy = -1.7976931348623157E308;
        class_2350 bestSide = null;
        for (class_2350 side : class_2350.values()) {
            double relevancy;
            class_2338 neighbor = blockPos.method_10093(side);
            class_2680 state = ClientMain.mc.field_1687.method_8320(neighbor);
            if (state.method_26215() || BlockUtils.isClickable(state.method_26204()) || !state.method_26227().method_15769() || !((relevancy = side.method_10166().method_10172(lookVec.method_10216(), lookVec.method_10214(), lookVec.method_10215()) * (double)side.method_10171().method_10181()) > bestRelevancy)) continue;
            bestRelevancy = relevancy;
            bestSide = side;
        }
        return bestSide;
    }

    public static boolean isClickable(class_2248 block) {
        return block instanceof class_2304 || block instanceof class_2199 || block instanceof class_2406 || block instanceof class_3711 || block instanceof class_3713 || block instanceof class_3718 || block instanceof class_2269 || block instanceof class_2231 || block instanceof class_2237 || block instanceof class_2244 || block instanceof class_2349 || block instanceof class_2323 || block instanceof class_2428 || block instanceof class_2533 || block instanceof class_2281 || block instanceof class_2336 || block instanceof class_3708 || block instanceof class_2508;
    }

    public static CompletableFuture<List<class_3545<class_2338, class_2248>>> getStorageBlocksAsync() {
        return CompletableFuture.supplyAsync(() -> BlockUtils.getEntityBlocksMatching(storage::contains), executor);
    }

    public static CompletableFuture<List<class_3545<class_2338, class_2248>>> getOreBlocksAsync() {
        return CompletableFuture.supplyAsync(() -> BlockUtils.getBlocksMatching(ore::contains), executor);
    }

    public static CompletableFuture<List<class_3545<class_2338, class_2248>>> getExposedOreAsync() {
        return CompletableFuture.supplyAsync(() -> BlockUtils.getBlocksMatching(pos -> {
            class_2680 state = ClientMain.mc.field_1687.method_8320(pos);
            return ore.contains(state.method_26204()) && BlockUtils.isExposedToAir(pos);
        }), executor);
    }

    private static List<class_3545<class_2338, class_2248>> getBlocksMatching(Predicate<class_2338> condition) {
        ArrayList<class_3545<class_2338, class_2248>> foundBlocks = new ArrayList<class_3545<class_2338, class_2248>>();
        WorldUtils.getLoadedChunks().forEach(chunk -> {
            class_1923 chunkPos = chunk.method_12004();
            int startX = chunkPos.method_8326();
            int startZ = chunkPos.method_8328();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < ClientMain.mc.field_1687.method_31605(); ++y) {
                        class_2338 pos = new class_2338(startX + x, y, startZ + z);
                        class_2680 state = chunk.method_8320(pos);
                        if (!condition.test(pos)) continue;
                        foundBlocks.add(new class_3545((Object)pos, (Object)state.method_26204()));
                    }
                }
            }
        });
        return foundBlocks;
    }

    private static List<class_3545<class_2338, class_2248>> getEntityBlocksMatching(Predicate<class_2248> condition) {
        ArrayList<class_3545<class_2338, class_2248>> foundBlocks = new ArrayList<class_3545<class_2338, class_2248>>();
        WorldUtils.getLoadedChunks().forEach(chunk -> chunk.method_12214().values().forEach(blockEntity -> {
            class_2338 pos = blockEntity.method_11016();
            class_2680 state = chunk.method_8320(pos);
            if (condition.test(state.method_26204())) {
                foundBlocks.add(new class_3545((Object)pos, (Object)state.method_26204()));
            }
        }));
        return foundBlocks;
    }

    private static boolean isExposedToAir(class_2338 pos) {
        return ClientMain.mc.field_1687.method_8320(pos.method_10084()).method_26215() || ClientMain.mc.field_1687.method_8320(pos.method_10074()).method_26215() || ClientMain.mc.field_1687.method_8320(pos.method_10095()).method_26215() || ClientMain.mc.field_1687.method_8320(pos.method_10072()).method_26215() || ClientMain.mc.field_1687.method_8320(pos.method_10078()).method_26215() || ClientMain.mc.field_1687.method_8320(pos.method_10067()).method_26215();
    }
}

