/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.streamproof;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.sun.jna.Function;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.utils.streamproof.Kernel32;
import net.fabricmc.fabric.utils.streamproof.MinHook;
import net.fabricmc.fabric.utils.streamproof.MinHookManager;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_9801;
import org.apache.commons.compress.utils.IOUtils;

public class OverlayRenderer {
    private static PointerByReference reference;
    private static boolean framebufferDirty;
    private static class_276 overlayFramebuffer;

    public static void markFramebufferDirty() {
        framebufferDirty = true;
    }

    public static void beginDraw() {
        if (overlayFramebuffer == null) {
            return;
        }
        overlayFramebuffer.method_1235(false);
        framebufferDirty = true;
    }

    public static void beginEmptyDraw() {
        class_310.method_1551().method_1522().method_1240();
    }

    public static void endDraw() {
        if (overlayFramebuffer == null) {
            return;
        }
        class_310.method_1551().method_1522().method_1235(false);
        framebufferDirty = true;
    }

    public static void onResolutionChanged(class_310 client) {
        if (overlayFramebuffer == null) {
            return;
        }
        overlayFramebuffer.method_1234(client.method_22683().method_4489(), client.method_22683().method_4506(), class_310.field_1703);
    }

    public static void beginFrame() {
        if (overlayFramebuffer == null) {
            return;
        }
        overlayFramebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        overlayFramebuffer.method_1230(class_310.field_1703);
    }

    private static void renderFrame() {
        class_310 client = class_310.method_1551();
        if (overlayFramebuffer != null && framebufferDirty) {
            framebufferDirty = false;
            GlStateManager._disableDepthTest();
            GlStateManager._enableBlend();
            GlStateManager._blendFunc((int)770, (int)771);
            GlStateManager._viewport((int)0, (int)0, (int)client.method_22683().method_4489(), (int)client.method_22683().method_4506());
            class_310 minecraftClient = class_310.method_1551();
            class_5944 shaderProgram = Objects.requireNonNull(minecraftClient.field_1773.field_29403, "Blit shader not loaded");
            shaderProgram.method_34583("DiffuseSampler", (Object)overlayFramebuffer.method_30277());
            shaderProgram.method_34586();
            class_289 tessellator = RenderSystem.renderThreadTesselator();
            class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            float f = minecraftClient.method_22683().method_4489();
            float g = minecraftClient.method_22683().method_4506();
            float h = (float)OverlayRenderer.overlayFramebuffer.field_1480 / (float)OverlayRenderer.overlayFramebuffer.field_1482;
            float i = (float)OverlayRenderer.overlayFramebuffer.field_1477 / (float)OverlayRenderer.overlayFramebuffer.field_1481;
            bufferBuilder.method_22912(0.0f, g, 0.0f).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255);
            bufferBuilder.method_22912(f, g, 0.0f).method_22913(h, 0.0f).method_1336(255, 255, 255, 255);
            bufferBuilder.method_22912(f, 0.0f, 0.0f).method_22913(h, i).method_1336(255, 255, 255, 255);
            bufferBuilder.method_22912(0.0f, 0.0f, 0.0f).method_22913(0.0f, i).method_1336(255, 255, 255, 255);
            class_286.method_43437((class_9801)bufferBuilder.method_60800());
            shaderProgram.method_34585();
        }
    }

    public static void setupLibs() {
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean is64 = arch.equals("x86_64") || arch.equals("amd64") || arch.equals("x64") || arch.equals("ia64");
        InputStream libFile = ClientMain.class.getResourceAsStream(is64 ? "/assets/tulip/lib/MinHook.x64.dll" : "/assets/tulip/lib/MinHook.x86.dll");
        if (libFile == null) {
            System.out.println("Failed to load dependency DLL");
            return;
        }
        File nativeDir = new File(FabricLoader.getInstance().getGameDir().toAbsolutePath().toString().concat("/native"));
        File copyLibFile = new File(FabricLoader.getInstance().getGameDir().toAbsolutePath().toString().concat("/native/MinHook.dll"));
        nativeDir.mkdir();
        try {
            FileOutputStream fos = new FileOutputStream(copyLibFile);
            copyLibFile.createNewFile();
            IOUtils.copy((InputStream)libFile, (OutputStream)fos);
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.setProperty("jna.library.path", nativeDir.getAbsolutePath());
    }

    public static void init(class_310 client) {
        overlayFramebuffer = new class_6367(client.method_22683().method_4489(), client.method_22683().method_4506(), true, class_310.field_1703);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        overlayFramebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        overlayFramebuffer.method_1230(class_310.field_1703);
        Pointer module = Kernel32.INSTANCE.GetModuleHandleA("opengl32.dll");
        Pointer proc = Kernel32.INSTANCE.GetProcAddress(module, "wglSwapBuffers");
        try {
            MinHook minhook = MinHookManager.GetInstance();
            minhook.MH_Initialize();
            reference = new PointerByReference();
            minhook.MH_CreateHook(proc, hDc -> {
                OverlayRenderer.renderFrame();
                Function origFunction = Function.getFunction((Pointer)reference.getValue(), (int)63);
                return (Boolean)origFunction.invoke(Boolean.class, new Object[]{hDc});
            }, reference);
            minhook.MH_EnableHook(proc);
        }
        catch (Exception e) {
            overlayFramebuffer = null;
        }
    }

    static {
        framebufferDirty = false;
        overlayFramebuffer = null;
    }
}

