/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.fabricmc.fabric.utils.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Render3DEngine {
    public static void drawBox(class_243 pos, Color color, class_4587 stack) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        float boxWidth = 0.3f;
        float boxHeight = 1.8f;
        class_243 start = pos.method_1020(camPos);
        float x = (float)start.field_1352;
        float y = (float)start.field_1351;
        float z = (float)start.field_1350;
        stack.method_22903();
        Matrix4f matrix = stack.method_23760().method_23761();
        RenderSystem.enableBlend();
        GL11.glDepthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        GL11.glDepthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        stack.method_22909();
    }

    public static void drawOrb(class_4587 matrices, class_243 lastPos, class_243 newPos, float radius, Color color) {
        double x = (lastPos.field_1352 + newPos.field_1352) / 2.0;
        double y = (lastPos.field_1351 + newPos.field_1351) / 2.0;
        double z = (lastPos.field_1350 + newPos.field_1350) / 2.0;
        matrices.method_22903();
        matrices.method_22904(x, y, z);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        Render3DEngine.drawCircle3D(matrices, 0.0, 0.0, 0.0, radius * 1.5f, new Color(color.getRed(), color.getGreen(), color.getBlue(), 50));
        Render3DEngine.drawCircle3D(matrices, 0.0, 0.0, 0.0, radius, color);
        matrices.method_22909();
        RenderSystem.disableBlend();
    }

    private static void drawCircle3D(class_4587 matrices, double x, double y, double z, float radius, Color color) {
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        buffer.method_22918(positionMatrix, (float)x, (float)y, (float)z).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        int segments = 50;
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float dx = (float)(x + Math.cos(angle) * (double)radius);
            float dz = (float)(z + Math.sin(angle) * (double)radius);
            buffer.method_22918(positionMatrix, dx, (float)y, dz).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
            class_286.method_43433((class_9801)buffer.method_60800());
        }
    }

    public static void drawBoxWithParams(class_243 pos, Color color, class_4587 stack, float boxWidth, float boxHeight) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        class_243 start = pos.method_1020(camPos);
        float x = (float)start.field_1352;
        float y = (float)start.field_1351;
        float z = (float)start.field_1350;
        stack.method_22903();
        Matrix4f matrix = stack.method_23760().method_23761();
        RenderSystem.enableBlend();
        GL11.glDepthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        GL11.glDepthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        stack.method_22909();
    }

    private static float getPlayerEyeHeight(class_746 player) {
        return player.method_18381(class_4050.field_18076);
    }

    public static void drawDynamicHealthBar(class_1657 entity, class_4587 stack, float width, float height, int alpha) {
    }

    public static Color interpolateHealthColor(float healthRatio, int alpha) {
        int red;
        int green;
        if (healthRatio > 0.5f) {
            green = 255;
            red = (int)(510.0f * (1.0f - healthRatio));
        } else {
            red = 255;
            green = (int)(510.0f * healthRatio);
        }
        return new Color(red, green, 0, alpha);
    }

    public static void drawEntityBox(class_1657 entity, Color boxColor, Color lineColor, class_4587 stack, float width, float height) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        class_243 playerPos = entity.method_30950(Utils.getTick());
        float red = (float)boxColor.getRed() / 255.0f;
        float green = (float)boxColor.getGreen() / 255.0f;
        float blue = (float)boxColor.getBlue() / 255.0f;
        float alpha = (float)boxColor.getAlpha() / 255.0f;
        float lineRed = (float)lineColor.getRed() / 255.0f;
        float lineGreen = (float)lineColor.getGreen() / 255.0f;
        float lineBlue = (float)lineColor.getBlue() / 255.0f;
        float lineAlpha = (float)lineColor.getAlpha() / 255.0f;
        float boxWidth = width;
        float boxHeight = height;
        class_243 start = playerPos.method_1020(camPos);
        float x = (float)start.field_1352;
        float y = (float)start.field_1351;
        float z = (float)start.field_1350;
        stack.method_22903();
        Matrix4f matrix = stack.method_23760().method_23761();
        RenderSystem.enableBlend();
        GL11.glDepthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.setShader(class_757::method_34540);
        buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.lineWidth((float)5.0f);
        Render3DEngine.drawLine2D(buffer, matrix, x - boxWidth, y, z - boxWidth, x + boxWidth, y, z - boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x + boxWidth, y, z - boxWidth, x + boxWidth, y, z + boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x + boxWidth, y, z + boxWidth, x - boxWidth, y, z + boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x - boxWidth, y, z + boxWidth, x - boxWidth, y, z - boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x - boxWidth, y + boxHeight, z - boxWidth, x + boxWidth, y + boxHeight, z - boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x + boxWidth, y + boxHeight, z - boxWidth, x + boxWidth, y + boxHeight, z + boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x + boxWidth, y + boxHeight, z + boxWidth, x - boxWidth, y + boxHeight, z + boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x - boxWidth, y + boxHeight, z + boxWidth, x - boxWidth, y + boxHeight, z - boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x - boxWidth, y, z - boxWidth, x - boxWidth, y + boxHeight, z - boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x + boxWidth, y, z - boxWidth, x + boxWidth, y + boxHeight, z - boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x + boxWidth, y, z + boxWidth, x + boxWidth, y + boxHeight, z + boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        Render3DEngine.drawLine2D(buffer, matrix, x - boxWidth, y, z + boxWidth, x - boxWidth, y + boxHeight, z + boxWidth, lineRed, lineGreen, lineBlue, lineAlpha);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        GL11.glDepthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        stack.method_22909();
    }

    public static void drawLine(class_243 lastPos, class_243 pos, Color color, class_4587 stack) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        stack.method_22903();
        Matrix4f matrix = stack.method_23760().method_23761();
        RenderSystem.enableBlend();
        GL11.glDepthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        class_243 start = lastPos.method_1020(camPos);
        float startX = (float)start.field_1352;
        float startY = (float)start.field_1351;
        float startZ = (float)start.field_1350;
        class_243 end = pos.method_1020(camPos);
        float endX = (float)end.field_1352;
        float endY = (float)end.field_1351;
        float endZ = (float)end.field_1350;
        buffer.method_22918(matrix, startX, startY, startZ).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, endX, endY, endZ).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        GL11.glDepthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        stack.method_22909();
    }

    public static void drawLine2D(class_287 buffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        buffer.method_22918(matrix, x1, y1, z1).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x2, y2, z2).method_22915(red, green, blue, alpha);
    }

    public static void drawRectangleOutline(class_4587 matrices, class_287 buffer, double x, double y, double z, Color color) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        float size = 1.0f;
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        Render3DEngine.addLine(buffer, matrix, (float)x, (float)y, (float)z, (float)(x + (double)size), (float)y, (float)z, red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)(x + (double)size), (float)y, (float)z, (float)(x + (double)size), (float)y, (float)(z + (double)size), red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)(x + (double)size), (float)y, (float)(z + (double)size), (float)x, (float)y, (float)(z + (double)size), red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)x, (float)y, (float)(z + (double)size), (float)x, (float)y, (float)z, red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)x, (float)(y + (double)size), (float)z, (float)(x + (double)size), (float)(y + (double)size), (float)z, red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)(x + (double)size), (float)(y + (double)size), (float)z, (float)(x + (double)size), (float)(y + (double)size), (float)(z + (double)size), red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)(x + (double)size), (float)(y + (double)size), (float)(z + (double)size), (float)x, (float)(y + (double)size), (float)(z + (double)size), red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)x, (float)(y + (double)size), (float)(z + (double)size), (float)x, (float)(y + (double)size), (float)z, red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)x, (float)y, (float)z, (float)x, (float)(y + (double)size), (float)z, red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)(x + (double)size), (float)y, (float)z, (float)(x + (double)size), (float)(y + (double)size), (float)z, red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)(x + (double)size), (float)y, (float)(z + (double)size), (float)(x + (double)size), (float)(y + (double)size), (float)(z + (double)size), red, green, blue, alpha);
        Render3DEngine.addLine(buffer, matrix, (float)x, (float)y, (float)(z + (double)size), (float)x, (float)(y + (double)size), (float)(z + (double)size), red, green, blue, alpha);
    }

    public static void drawFilledRectangle(class_4587 matrices, class_287 buffer, float x, float y, float z, float boxWidth, float boxHeight, Color color) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z - boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z + boxWidth).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x - boxWidth, y + boxHeight, z - boxWidth).method_22915(red, green, blue, alpha);
    }

    public static void renderRoundedQuad3D(class_4587 matrixStack, float x, float y, float width, float height, float radius, Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        GL11.glDepthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_22918(matrix, x + radius, y + radius, 0.0f).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + radius, y + height - radius, 0.0f).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + width - radius, y + height - radius, 0.0f).method_22915(red, green, blue, alpha);
        buffer.method_22918(matrix, x + width - radius, y + radius, 0.0f).method_22915(red, green, blue, alpha);
        Render3DEngine.drawCorner(matrix, buffer, x + radius, y + radius, radius, 180, 270, red, green, blue, alpha);
        Render3DEngine.drawCorner(matrix, buffer, x + width - radius, y + radius, radius, 270, 360, red, green, blue, alpha);
        Render3DEngine.drawCorner(matrix, buffer, x + width - radius, y + height - radius, radius, 0, 90, red, green, blue, alpha);
        Render3DEngine.drawCorner(matrix, buffer, x + radius, y + height - radius, radius, 90, 180, red, green, blue, alpha);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        GL11.glDepthFunc((int)515);
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.defaultBlendFunc();
    }

    private static void drawCorner(Matrix4f matrix, class_287 buffer, float cx, float cy, float radius, int startAngle, int endAngle, float red, float green, float blue, float alpha) {
        for (int i = startAngle; i <= endAngle; i += 11) {
            double angle = Math.toRadians(i);
            float x = (float)((double)cx + Math.cos(angle) * (double)radius);
            float y = (float)((double)cy + Math.sin(angle) * (double)radius);
            buffer.method_22918(matrix, x, y, 0.0f).method_22915(red, green, blue, alpha);
        }
    }

    private static void addQuad(class_287 buffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b, float alpha) {
        buffer.method_22918(matrix, x1, y1, z1).method_22915(r, g, b, alpha);
        buffer.method_22918(matrix, x2, y2, z2).method_22915(r, g, b, alpha);
        buffer.method_22918(matrix, x3, y3, z3).method_22915(r, g, b, alpha);
        buffer.method_22918(matrix, x3, y3, z3).method_22915(r, g, b, alpha);
        buffer.method_22918(matrix, x4, y4, z4).method_22915(r, g, b, alpha);
        buffer.method_22918(matrix, x1, y1, z1).method_22915(r, g, b, alpha);
    }

    private static void addLine(class_287 buffer, Matrix4f matrix, float startX, float startY, float startZ, float endX, float endY, float endZ, float r, float g, float b, float alpha) {
        buffer.method_22918(matrix, startX, startY, startZ).method_22915(r, g, b, alpha);
        buffer.method_22918(matrix, endX, endY, endZ).method_22915(r, g, b, alpha);
    }
}

