/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.render;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.utils.render.RenderHelper;
import net.fabricmc.fabric.utils.shader.BlurProgram;
import net.fabricmc.fabric.utils.shader.CircleProgram;
import net.fabricmc.fabric.utils.shader.GlowProgram;
import net.fabricmc.fabric.utils.shader.OutlineProgram;
import net.fabricmc.fabric.utils.shader.RectangleProgram;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_8685;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Render2DEngine {
    private static class_243 eyesPos;
    public static class_8251 vertexSorter;
    public static boolean rendering3D;
    public static BlurProgram BLUR_PROGRAM;
    public static RectangleProgram RECT_PROGRAM;
    public static CircleProgram CIRCLE_PROGRAM;
    public static GlowProgram GLOW_PROGRAM;
    public static OutlineProgram OUTLINE_PROGRAM;

    public static void unscaledProjection() {
        vertexSorter = RenderSystem.getVertexSorting();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)ClientMain.mc.method_22683().method_4489(), (float)ClientMain.mc.method_22683().method_4506(), 0.0f, 1000.0f, 21000.0f), (class_8251)class_8251.field_43361);
        rendering3D = false;
    }

    public static void scaledProjection() {
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)((double)ClientMain.mc.method_22683().method_4489() / ClientMain.mc.method_22683().method_4495()), (float)((double)ClientMain.mc.method_22683().method_4506() / ClientMain.mc.method_22683().method_4495()), 0.0f, 1000.0f, 21000.0f), (class_8251)vertexSorter);
        rendering3D = true;
    }

    public static void fill(@NotNull class_4587 matrices, double x1, double y1, double x2, double y2, int color) {
        double i;
        Render2DEngine.setupRender();
        Matrix4f matrix = matrices.method_23760().method_23761();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float j = (float)(color & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(g, h, j, f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(g, h, j, f);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(g, h, j, f);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(g, h, j, f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
        Render2DEngine.endRender();
    }

    public static void drawLine(@NotNull class_4587 matrices, double x1, double y1, double x2, double y2, float thickness, Color color) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length == 0.0) {
            return;
        }
        double controlX = (x1 + x2) / 2.0 + (dy /= length) * (double)thickness;
        double controlY = (y1 + y2) / 2.0 - (dx /= length) * (double)thickness;
        int segments = 10;
        for (int i = 0; i <= segments; ++i) {
            double nextT = (double)(i + 1) / (double)segments;
            double nextX = (1.0 - nextT) * (1.0 - nextT) * x1 + 2.0 * (1.0 - nextT) * nextT * controlX + nextT * nextT * x2;
            double t = (double)i / (double)segments;
            double x = (1.0 - t) * (1.0 - t) * x1 + 2.0 * (1.0 - t) * t * controlX + t * t * x2;
            double dx2 = nextX - x;
            double nextY = (1.0 - nextT) * (1.0 - nextT) * y1 + 2.0 * (1.0 - nextT) * nextT * controlY + nextT * nextT * y2;
            double y = (1.0 - t) * (1.0 - t) * y1 + 2.0 * (1.0 - t) * t * controlY + t * t * y2;
            double dy2 = nextY - y;
            double len = Math.sqrt(dx2 * dx2 + dy2 * dy2);
            if (len == 0.0) continue;
            double px = -(dy2 /= len) * ((double)thickness / 2.0);
            double py = (dx2 /= len) * ((double)thickness / 2.0);
            double x1a = x + px;
            double y1a = y + py;
            double x1b = x - px;
            double y1b = y - py;
            double x2a = nextX + px;
            double y2a = nextY + py;
            double x2b = nextX - px;
            double y2b = nextY - py;
            int rgba = (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
            Render2DEngine.setupRender();
            Matrix4f matrix = matrices.method_23760().method_23761();
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(class_757::method_34540);
            float r = (float)(rgba >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgba >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgba & 0xFF) / 255.0f;
            float a = (float)(rgba >> 24 & 0xFF) / 255.0f;
            bufferBuilder.method_22918(matrix, (float)x1a, (float)y1a, 0.0f).method_22915(r, g, b, a * 0.8f);
            bufferBuilder.method_22918(matrix, (float)x2a, (float)y2a, 0.0f).method_22915(r, g, b, a * 0.8f);
            bufferBuilder.method_22918(matrix, (float)x2b, (float)y2b, 0.0f).method_22915(r, g, b, a * 0.8f);
            bufferBuilder.method_22918(matrix, (float)x1b, (float)y1b, 0.0f).method_22915(r, g, b, a * 0.8f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            RenderSystem.disableBlend();
            Render2DEngine.endRender();
        }
    }

    public static double interpolate(double oldValue, double newValue, double interpolationValue) {
        return oldValue + (newValue - oldValue) * interpolationValue;
    }

    public static void drawPlayerHead(class_332 context, class_1657 player, float x, float y, int size) {
        Render2DEngine.setupRender();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && player != null) {
            GameProfile gameProfile = new GameProfile(player.method_5667(), player.method_5477().getString());
            class_640 playerListEntry = mc.field_1724.field_3944.method_2871(gameProfile.getId());
            boolean bl3 = player.method_7348(class_1664.field_7563);
            if (playerListEntry == null) {
                return;
            }
            class_8685 playerSkinIdentifier = playerListEntry.method_52810();
            if (playerListEntry != null) {
                RenderSystem.setShaderTexture((int)0, (class_2960)playerListEntry.method_52810().comp_1626());
            }
            class_7532.method_44445((class_332)context, (class_2960)playerSkinIdentifier.comp_1626(), (int)((int)x), (int)((int)y), (int)size, (boolean)bl3, (boolean)false);
        }
        Render2DEngine.endRender();
    }

    public static void drawCircle(class_4587 matrices, float cx, float cy, float r, Color color) {
        class_289 tess = class_289.method_1348();
        class_287 buffer = tess.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f matrix = matrices.method_23760().method_23761();
        buffer.method_22918(matrix, cx, cy, 0.0f).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int i = 0; i <= 360; ++i) {
            double angle = Math.toRadians(i);
            float x = (float)((double)cx + Math.cos(angle) * (double)r);
            float y = (float)((double)cy + Math.sin(angle) * (double)r);
            buffer.method_22918(matrix, x, y, 0.0f).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static class_2960 getTexture(class_1657 player) {
        if (player == null) {
            return null;
        }
        GameProfile gameProfile = new GameProfile(player.method_5667(), player.method_5477().getString());
        assert (class_310.method_1551().field_1724 != null);
        class_640 playerListEntry = class_310.method_1551().field_1724.field_3944.method_2871(gameProfile.getId());
        if (playerListEntry == null) {
            return null;
        }
        return playerListEntry.method_52810().comp_1626();
    }

    public static void drawRoundTexture(class_332 context, class_2960 texture, int x, int y, int w, int h, int r) {
        class_287 buf = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1585);
        Matrix4f mat = context.method_51448().method_23760().method_23761();
        buf.method_22918(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).method_22913(0.5f, 0.5f);
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                float u = (rx - (float)x) / (float)w;
                float v = (ry - (float)y) / (float)h;
                buf.method_22918(mat, rx, ry, 0.0f).method_22913(u, v);
            }
        }
        buf.method_22918(mat, (float)corners[0][0], (float)y, 0.0f).method_22913(((float)corners[0][0] - (float)x) / (float)w, 0.0f);
        RenderSystem.disableCull();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_286.method_43433((class_9801)buf.method_60800());
        RenderSystem.enableCull();
    }

    public static void drawHollowRect(class_4587 matrixStack, int x, int y, int width, int height, int thickness, Color color) {
        Render2DEngine.setupRender();
        Render2DEngine.fill(matrixStack, x, y - thickness, x - thickness, y + height + thickness, color.getRGB());
        Render2DEngine.fill(matrixStack, x + width, y - thickness, x + width + thickness, y + height + thickness, color.getRGB());
        Render2DEngine.fill(matrixStack, x, y, x + width, y - thickness, color.getRGB());
        Render2DEngine.fill(matrixStack, x, y + height, x + width, y + height + thickness, color.getRGB());
        Render2DEngine.endRender();
    }

    public static void drawTexturedRectangle(class_332 matrices, float x, float y, int width, int height, class_2960 path) {
        matrices.method_25290(path, (int)x, (int)y, 0.0f, 0.0f, width, height, width, height);
    }

    public static void color(Color color) {
        if (color == null) {
            color = Color.white;
        }
        Render2DEngine.color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    public static void color(double red, double green, double blue, double alpha) {
        GL11.glColor4d((double)red, (double)green, (double)blue, (double)alpha);
    }

    public static void renderRoundedQuad(@NotNull class_4587 matrices, double fromX, double fromY, double toX, double toY, double rad, double samples, Color c) {
        Render2DEngine.setupRender();
        int color = c.getRGB();
        Matrix4f matrix = matrices.method_23760().method_23761();
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        GL11.glEnable((int)32925);
        Render2DEngine.renderRoundedQuadInternal(matrix, g, h, k, f, fromX, fromY, toX, toY, rad, samples);
        GL11.glDisable((int)32925);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Render2DEngine.endRender();
    }

    private static void drawRoundedRectangleOutline(Matrix4f matrix, double x, double y, double width, double height, double radius, double samples, float red, float green, float blue, float alpha, float thickness) {
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        int i = 0;
        while ((double)i <= samples) {
            double angle = (double)i / samples * 1.5707963267948966;
            float xOffset = (float)(Math.cos(angle) * radius);
            float yOffset = (float)(Math.sin(angle) * radius);
            Render2DEngine.vertex(bufferBuilder, matrix, (float)(x + radius - (double)xOffset), (float)(y + radius - (double)yOffset), red, green, blue, alpha);
            Render2DEngine.vertex(bufferBuilder, matrix, (float)(width - radius + (double)xOffset), (float)(y + radius - (double)yOffset), red, green, blue, alpha);
            Render2DEngine.vertex(bufferBuilder, matrix, (float)(width - radius + (double)xOffset), (float)(height - radius + (double)yOffset), red, green, blue, alpha);
            Render2DEngine.vertex(bufferBuilder, matrix, (float)(x + radius - (double)xOffset), (float)(height - radius + (double)yOffset), red, green, blue, alpha);
            ++i;
        }
        bufferBuilder.method_60800();
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private static void vertex(class_287 bufferBuilder, Matrix4f matrix, float x, float y, float r, float g, float b, float a) {
        bufferBuilder.method_22918(matrix, x, y, 0.0f).method_22915(r, g, b, a);
    }

    public static void renderRoundedShadow(class_332 poses, Color innerColor, double fromX, double fromY, double toX, double toY, double rad, double samples, double shadowWidth) {
        int color = innerColor.getRGB();
        Matrix4f matrix = poses.method_51448().method_23760().method_23761();
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        Render2DEngine.setupRender();
        RenderSystem.setShader(class_757::method_34540);
        Render2DEngine.renderRoundedShadowInternal(matrix, g, h, k, f, fromX, fromY, toX, toY, rad, samples, shadowWidth);
        Render2DEngine.endRender();
    }

    public static void renderRoundedShadowInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, double fromX, double fromY, double toX, double toY, double rad, double samples, double wid) {
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        double toX1 = toX - rad;
        double toY1 = toY - rad;
        double fromX1 = fromX + rad;
        double fromY1 = fromY + rad;
        double[][] map = new double[][]{{toX1, toY1}, {toX1, fromY1}, {fromX1, fromY1}, {fromX1, toY1}};
        for (int i = 0; i < map.length; ++i) {
            double[] current = map[i];
            for (double r = (double)i * 90.0; r < 90.0 + (double)i * 90.0; r += 90.0 / samples) {
                float rad1 = (float)Math.toRadians(r);
                float sin = (float)(Math.sin(rad1) * rad);
                float cos = (float)(Math.cos(rad1) * rad);
                bufferBuilder.method_22918(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).method_22915(cr, cg, cb, ca);
                float sin1 = (float)((double)sin + Math.sin(rad1) * wid);
                float cos1 = (float)((double)cos + Math.cos(rad1) * wid);
                bufferBuilder.method_22918(matrix, (float)current[0] + sin1, (float)current[1] + cos1, 0.0f).method_22915(cr, cg, cb, 0.0f);
            }
        }
        double[] current = map[0];
        float rad1 = (float)Math.toRadians(0.0);
        float sin = (float)(Math.sin(rad1) * rad);
        float cos = (float)(Math.cos(rad1) * rad);
        bufferBuilder.method_22918(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).method_22915(cr, cg, cb, ca);
        float sin1 = (float)((double)sin + Math.sin(rad1) * wid);
        float cos1 = (float)((double)cos + Math.cos(rad1) * wid);
        bufferBuilder.method_22918(matrix, (float)current[0] + sin1, (float)current[1] + cos1, 0.0f).method_22915(cr, cg, cb, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public static void renderRoundedQuadInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, double fromX, double fromY, double toX, double toY, double rad, double samples) {
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        double toX1 = toX - rad;
        double toY1 = toY - rad;
        double fromX1 = fromX + rad;
        double fromY1 = fromY + rad;
        double[][] map = new double[][]{{toX1, toY1}, {toX1, fromY1}, {fromX1, fromY1}, {fromX1, toY1}};
        for (int i = 0; i < 4; ++i) {
            double[] current = map[i];
            for (double r = (double)i * 90.0; r < 90.0 + (double)i * 90.0; r += 90.0 / samples) {
                float rad1 = (float)Math.toRadians(r);
                float sin = (float)(Math.sin(rad1) * rad);
                float cos = (float)(Math.cos(rad1) * rad);
                bufferBuilder.method_22918(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).method_22915(cr, cg, cb, ca);
            }
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public static void drawCircle(class_4587 matrices, double centerX, double centerY, double radius, double samples, Color color) {
        Render2DEngine.drawCircle(matrices, color, centerX, centerY, radius, (int)samples);
    }

    public static void drawCircle(class_4587 matrices, Color c, double originX, double originY, double rad, int segments) {
        int segments1 = class_3532.method_15340((int)segments, (int)4, (int)360);
        int color = c.getRGB();
        Matrix4f matrix = matrices.method_23760().method_23761();
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        Render2DEngine.setupRender();
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        for (int i = 0; i < 360; i += Math.min(360 / segments1, 360 - i)) {
            double radians = Math.toRadians(i);
            double sin = Math.sin(radians) * rad;
            double cos = Math.cos(radians) * rad;
            bufferBuilder.method_22918(matrix, (float)(originX + sin), (float)(originY + cos), 0.0f).method_22915(g, h, k, f);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        Render2DEngine.endRender();
    }

    public static void renderItem(class_4587 matrixStack, class_1799 itemStack, float x, float y, float scale, boolean renderOverlay) {
        RenderSystem.disableDepthTest();
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, 1.0f);
        RenderHelper.getContext().method_51427(itemStack, (int)(x / scale), (int)(y / scale));
        if (renderOverlay) {
            RenderHelper.getContext().method_51431(class_310.method_1551().field_1772, itemStack, (int)(x / scale), (int)(y / scale));
        }
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
    }

    public static void drawRoundedBlur(class_4587 matrices, float x, float y, float width, float height, float radius, float blurStrength, float blurOpacity, boolean vignette) {
        if (vignette) {
            Render2DEngine.renderRoundedShadow(RenderHelper.getContext(), new Color(0, 0, 0, 80), x, y, x + width, y + height, radius, 16.0, 6.0);
        }
        class_287 bb = Render2DEngine.preShaderDraw(matrices, x, y, width, height);
        BLUR_PROGRAM.setParameters(x, y, width, height, radius, blurStrength, blurOpacity);
        BLUR_PROGRAM.use();
        class_286.method_43433((class_9801)bb.method_60800());
        Render2DEngine.endRender();
    }

    public static void drawRectangle(class_4587 matrices, float x, float y, float width, float height, float radius, float smoothness, Color c1) {
        class_287 bb = Render2DEngine.preShaderDraw(matrices, x - 10.0f, y - 10.0f, width + 20.0f, height + 20.0f);
        RECT_PROGRAM.setParameters(x, y, width, height, radius, smoothness, c1, c1, c1, c1);
        RECT_PROGRAM.use();
        class_286.method_43433((class_9801)bb.method_60800());
        Render2DEngine.endRender();
    }

    public static void drawGradientRectangle(class_4587 matrices, float x, float y, float width, float height, float radius, float smoothness, Color c1, Color c2, Color c3, Color c4) {
        class_287 bb = Render2DEngine.preShaderDraw(matrices, x - 10.0f, y - 10.0f, width + 20.0f, height + 20.0f);
        RECT_PROGRAM.setParameters(x, y, width, height, radius, smoothness, c1, c2, c3, c4);
        RECT_PROGRAM.use();
        class_286.method_43433((class_9801)bb.method_60800());
        Render2DEngine.endRender();
    }

    public static void drawCircle(class_4587 matrices, float x, float y, float radius, float smoothness, Color c1) {
        Render2DEngine.drawRectangle(matrices, x, y, radius * 2.0f, radius * 2.0f, radius, smoothness, c1);
    }

    public static void drawGlow(class_4587 matrices, float x, float y, float width, float height, float radius, float smoothness, Color c1) {
        class_287 bb = Render2DEngine.preShaderDraw(matrices, x - 10.0f, y - 10.0f, width + 20.0f, height + 20.0f);
        GLOW_PROGRAM.setParameters(x, y, width, height, radius, smoothness, c1, c1, c1, c1);
        GLOW_PROGRAM.use();
        class_286.method_43433((class_9801)bb.method_60800());
        Render2DEngine.endRender();
    }

    public static void drawGradientGlow(class_4587 matrices, float x, float y, float width, float height, float radius, float smoothness, Color c1, Color c2, Color c3, Color c4) {
        class_287 bb = Render2DEngine.preShaderDraw(matrices, x - 10.0f, y - 10.0f, width + 20.0f, height + 20.0f);
        GLOW_PROGRAM.setParameters(x, y, width, height, radius, smoothness, c1, c2, c3, c4);
        GLOW_PROGRAM.use();
        class_286.method_43433((class_9801)bb.method_60800());
        Render2DEngine.endRender();
    }

    public static void drawOutline(class_4587 matrices, float x, float y, float width, float height, float radius, float smoothness, float thickness, Color c1) {
        class_287 bb = Render2DEngine.preShaderDraw(matrices, x - 10.0f, y - 10.0f, width + 20.0f, height + 20.0f);
        OUTLINE_PROGRAM.setParameters(x, y, width, height, radius, smoothness, thickness, c1, c1, c1, c1);
        OUTLINE_PROGRAM.use();
        class_286.method_43433((class_9801)bb.method_60800());
        Render2DEngine.endRender();
    }

    public static void betterScissor(double x, double y, double x2, double y2) {
        class_310 mc = class_310.method_1551();
        int xPercent = (int)(x / (double)mc.method_22683().method_4486());
        int yPercent = (int)(y / (double)mc.method_22683().method_4507());
        int widthPercent = (int)(x2 / (double)mc.method_22683().method_4480());
        int heightPercent = (int)(y2 / (double)mc.method_22683().method_4507());
        RenderSystem.enableScissor((int)xPercent, (int)yPercent, (int)widthPercent, (int)heightPercent);
    }

    public static void initShaders() {
        BLUR_PROGRAM = new BlurProgram();
        RECT_PROGRAM = new RectangleProgram();
        CIRCLE_PROGRAM = new CircleProgram();
        GLOW_PROGRAM = new GlowProgram();
        OUTLINE_PROGRAM = new OutlineProgram();
    }

    public static void setRectanglePoints(class_287 buffer, Matrix4f matrix, float x, float y, float x1, float y1) {
        buffer.method_22918(matrix, x, y, 0.0f);
        buffer.method_22918(matrix, x, y1, 0.0f);
        buffer.method_22918(matrix, x1, y1, 0.0f);
        buffer.method_22918(matrix, x1, y, 0.0f);
    }

    public static class_287 preShaderDraw(class_4587 matrices, float x, float y, float width, float height) {
        Render2DEngine.setupRender();
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        Render2DEngine.setRectanglePoints(buffer, matrix, x, y, x + width, y + height);
        return buffer;
    }

    public static void setupRender() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void endRender() {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        rendering3D = true;
    }
}

