/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.player;

import java.util.function.Predicate;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.utils.Utils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class RaycastUtils {
    @Nullable
    public static class_3965 raycastBlock(double maxDistance, class_3959.class_242 fluidHandling) {
        if (ClientMain.mc.field_1724 == null || ClientMain.mc.field_1687 == null) {
            return null;
        }
        class_243 eyePos = ClientMain.mc.field_1724.method_5836(Utils.getTick());
        class_243 lookVec = ClientMain.mc.field_1724.method_5828(Utils.getTick()).method_1029();
        class_243 targetPos = eyePos.method_1019(lookVec.method_1021(maxDistance));
        return ClientMain.mc.field_1687.method_17742(new class_3959(eyePos, targetPos, class_3959.class_3960.field_17559, fluidHandling, (class_1297)ClientMain.mc.field_1724));
    }

    @Nullable
    public static class_3966 raycastEntity(double maxDistance, Predicate<class_1297> targetPredicate, boolean ignoreSelf, float precision) {
        if (ClientMain.mc.field_1724 == null || ClientMain.mc.field_1687 == null) {
            return null;
        }
        class_243 eyePos = ClientMain.mc.field_1724.method_5836(Utils.getTick());
        class_243 lookVec = ClientMain.mc.field_1724.method_5828(Utils.getTick()).method_1029();
        class_3966 bestHit = null;
        double bestDistance = maxDistance;
        for (class_1297 entity : ClientMain.mc.field_1687.method_18112()) {
            if (!targetPredicate.test(entity) || ignoreSelf && entity == ClientMain.mc.field_1724) continue;
            class_238 expandedBox = entity.method_5829().method_1014(0.1);
            float step = 0.0f;
            while ((double)step < maxDistance) {
                double distance;
                class_243 checkPos = eyePos.method_1019(lookVec.method_1021((double)step));
                if (expandedBox.method_1006(checkPos) && (distance = eyePos.method_1022(checkPos)) < bestDistance) {
                    bestHit = new class_3966(entity, checkPos);
                    bestDistance = distance;
                }
                step += precision;
            }
        }
        return bestHit;
    }

    @Nullable
    public static class_239 raycast(double maxDistance, Predicate<class_1297> entityPredicate, boolean ignoreSelf, class_3959.class_242 fluidHandling, float precision) {
        class_3965 blockHit = RaycastUtils.raycastBlock(maxDistance, fluidHandling);
        class_3966 entityHit = RaycastUtils.raycastEntity(maxDistance, entityPredicate, ignoreSelf, precision);
        if (blockHit == null && entityHit == null) {
            return null;
        }
        double blockDistance = blockHit == null ? Double.MAX_VALUE : ClientMain.mc.field_1724.method_33571().method_1022(blockHit.method_17784());
        double entityDistance = entityHit == null ? Double.MAX_VALUE : ClientMain.mc.field_1724.method_33571().method_1022(entityHit.method_17784());
        return blockDistance <= entityDistance ? blockHit : entityHit;
    }

    @Nullable
    public static class_3966 raycastWithPrediction(double maxDistance, Predicate<class_1297> targetPredicate, boolean ignoreSelf, float predictionFactor, float precision) {
        if (ClientMain.mc.field_1724 == null || ClientMain.mc.field_1687 == null) {
            return null;
        }
        class_243 eyePos = ClientMain.mc.field_1724.method_5836(Utils.getTick());
        class_243 lookVec = ClientMain.mc.field_1724.method_5828(Utils.getTick()).method_1029();
        class_3966 bestHit = null;
        double bestDistance = maxDistance;
        for (class_1297 entity : ClientMain.mc.field_1687.method_18112()) {
            if (!targetPredicate.test(entity) || ignoreSelf && entity == ClientMain.mc.field_1724) continue;
            class_243 predictedPos = entity.method_19538().method_1019(entity.method_18798().method_1021((double)predictionFactor));
            class_238 predictedBox = new class_238(predictedPos.method_1023((double)(entity.method_17681() / 2.0f), 0.0, (double)(entity.method_17681() / 2.0f)), predictedPos.method_1031((double)(entity.method_17681() / 2.0f), (double)entity.method_17682(), (double)(entity.method_17681() / 2.0f))).method_1014(0.1);
            float step = 0.0f;
            while ((double)step < maxDistance) {
                double distance;
                class_243 checkPos = eyePos.method_1019(lookVec.method_1021((double)step));
                if (predictedBox.method_1006(checkPos) && (distance = eyePos.method_1022(checkPos)) < bestDistance) {
                    bestHit = new class_3966(entity, checkPos);
                    bestDistance = distance;
                }
                step += precision;
            }
        }
        return bestHit;
    }

    @Nullable
    public static class_3966 raycastIgnoringBlocks(double maxDistance, Predicate<class_1297> targetPredicate, boolean ignoreSelf, float precision) {
        if (ClientMain.mc.field_1724 == null || ClientMain.mc.field_1687 == null) {
            return null;
        }
        class_243 eyePos = ClientMain.mc.field_1724.method_5836(Utils.getTick());
        class_243 lookVec = ClientMain.mc.field_1724.method_5828(Utils.getTick()).method_1029();
        class_3966 bestHit = null;
        double bestDistance = maxDistance;
        for (class_1297 entity : ClientMain.mc.field_1687.method_18112()) {
            if (!targetPredicate.test(entity) || ignoreSelf && entity == ClientMain.mc.field_1724) continue;
            class_238 expandedBox = entity.method_5829().method_1014(0.1);
            float step = 0.0f;
            while ((double)step < maxDistance) {
                double distance;
                class_243 checkPos = eyePos.method_1019(lookVec.method_1021((double)step));
                if (expandedBox.method_1006(checkPos) && (distance = eyePos.method_1022(checkPos)) < bestDistance) {
                    bestHit = new class_3966(entity, checkPos);
                    bestDistance = distance;
                }
                step += precision;
            }
        }
        return bestHit;
    }

    private static boolean isBlockedByBlock(class_243 start, class_243 end) {
        class_3965 blockHit = ClientMain.mc.field_1687.method_17742(new class_3959(start, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)ClientMain.mc.field_1724));
        return blockHit.method_17783() == class_239.class_240.field_1332 && blockHit.method_17784().method_1025(start) < start.method_1025(end);
    }

    public static class_239 getHitResult(class_1657 entity, boolean ignoreInvisibles, float yaw, float pitch) {
        class_3965 result = null;
        if (entity != null && ClientMain.mc.field_1687 != null) {
            double d = ClientMain.mc.field_1724.method_55755();
            class_243 cameraPosVec = entity.method_5836(Utils.getTick());
            class_243 rotationVec = RaycastUtils.getPlayerLookVec(yaw, pitch);
            class_243 range = cameraPosVec.method_1031(rotationVec.field_1352 * d, rotationVec.field_1351 * d, rotationVec.field_1350 * d);
            result = ClientMain.mc.field_1687.method_17742(new class_3959(cameraPosVec, range, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)entity));
            boolean bl = false;
            double e = d;
            if (d > 3.0) {
                bl = true;
            }
            e *= e;
            if (result != null) {
                e = result.method_17784().method_1025(cameraPosVec);
            }
            class_243 vec3d3 = cameraPosVec.method_1031(rotationVec.field_1352 * d, rotationVec.field_1351 * d, rotationVec.field_1350 * d);
            float f = 1.0f;
            class_238 box = entity.method_5829().method_18804(rotationVec.method_1021(d)).method_1009(1.0, 1.0, 1.0);
            class_3966 entityHitResult = class_1675.method_18075((class_1297)entity, (class_243)cameraPosVec, (class_243)vec3d3, (class_238)box, entityx -> !entityx.method_7325() && entityx.method_5863() && entityx.method_5767() && !ignoreInvisibles, (double)e);
            if (entityHitResult != null) {
                class_243 vec3d4 = entityHitResult.method_17784();
                double g = cameraPosVec.method_1025(vec3d4);
                if (bl && g > 9.0) {
                    result = class_3965.method_17778((class_243)vec3d4, (class_2350)class_2350.method_10142((double)rotationVec.field_1352, (double)rotationVec.field_1351, (double)rotationVec.field_1350), (class_2338)class_2338.method_49638((class_2374)vec3d4));
                } else if (g < e || result == null) {
                    result = entityHitResult;
                }
            }
        }
        return result;
    }

    public static class_243 getPlayerLookVec(float yaw, float pitch) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    public static class_243 getPlayerLookVec(class_1657 player) {
        return RaycastUtils.getPlayerLookVec(player.method_36454(), player.method_36455());
    }

    public static boolean isLookingAt(class_1297 entity, double maxDistance, float precision) {
        class_3966 hitResult = RaycastUtils.raycastEntity(maxDistance, e -> e == entity, true, precision);
        return hitResult != null && hitResult.method_17782() == entity;
    }

    public static boolean canHitEntity(class_1297 entity, double maxDistance, float precision) {
        return RaycastUtils.raycastEntity(maxDistance, e -> e == entity, true, precision) != null;
    }

    public static class_243 getSurfaceNormal(class_3965 hit) {
        class_2350 dir = hit.method_17780();
        return new class_243((double)dir.method_10148(), (double)dir.method_10164(), (double)dir.method_10165());
    }

    public static boolean isFacingBlock(class_3965 hit, float thresholdAngle) {
        class_243 normal = RaycastUtils.getSurfaceNormal(hit);
        class_243 lookVec = ClientMain.mc.field_1724.method_5828(1.0f).method_1029();
        double dot = lookVec.method_1026(normal);
        return Math.toDegrees(Math.acos(dot)) <= (double)thresholdAngle;
    }
}

