/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.player;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.utils.Utils;
import net.fabricmc.fabric.utils.player.RaycastUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerUtils {
    public static JsonObject friends = new JsonObject();

    public static boolean isFriend(class_1657 player) {
        return friends.get(player.method_5845()) != null;
    }

    public static void addFriend(class_1657 player) {
        if (!PlayerUtils.isFriend(player)) {
            friends.add(player.method_5845(), (JsonElement)new JsonPrimitive(player.method_5477().getString()));
        }
    }

    public static void removeFriend(class_1657 player) {
        if (PlayerUtils.isFriend(player)) {
            friends.remove(player.method_5845());
        }
    }

    public static class_1657 findNearestPlayer(class_1657 toPlayer, float range, boolean seeOnly) {
        float minRange = Float.MAX_VALUE;
        class_1657 minPlayer = null;
        for (class_1657 player : ClientMain.mc.field_1687.method_18456()) {
            if (PlayerUtils.isFriend(player)) continue;
            float distance = player.method_5739((class_1297)toPlayer);
            if (player.method_5477().equals((Object)toPlayer.method_5477()) || player == toPlayer || !(distance <= range) || seeOnly && !toPlayer.method_6057((class_1297)player) || !(distance < minRange)) continue;
            minRange = distance;
            minPlayer = player;
        }
        return minPlayer;
    }

    public static class_1657 getLookedAtPlayer() {
        class_1297 entity;
        if (ClientMain.mc.field_1765 != null && ClientMain.mc.field_1765.method_17783() == class_239.class_240.field_1331 && (entity = ((class_3966)ClientMain.mc.field_1765).method_17782()) instanceof class_1657) {
            return (class_1657)entity;
        }
        return null;
    }

    public static boolean canCrit(class_1657 pe, boolean closeGroundCheck) {
        if (pe == null) {
            return false;
        }
        if (closeGroundCheck) {
            class_3965 bhr = RaycastUtils.raycastBlock(10.0, class_3959.class_242.field_1348);
            double y = pe.method_23318() - bhr.method_17784().method_10214();
            if (y <= 0.15) {
                return false;
            }
        }
        return !pe.method_6059(class_1294.field_5919) && !pe.method_6101() && !pe.method_5799() && !pe.method_5765() && !pe.method_24828() && pe.field_6017 > 0.065f && (double)pe.method_7261(0.5f) >= 0.7 && pe.method_60478().method_1027() < 1.0E-7;
    }

    public static float squaredDistanceFromEyes(@NotNull class_243 targetPos) {
        if (ClientMain.mc.field_1724 == null) {
            return 0.0f;
        }
        double dx = targetPos.field_1352 - ClientMain.mc.field_1724.method_23317();
        double dy = targetPos.field_1351 - (ClientMain.mc.field_1724.method_23318() + (double)ClientMain.mc.field_1724.method_18381(ClientMain.mc.field_1724.method_18376()));
        double dz = targetPos.field_1350 - ClientMain.mc.field_1724.method_23321();
        return (float)(dx * dx + dy * dy + dz * dz);
    }

    public static class_1309 findNearestEntity(class_1657 toPlayer, float range, boolean seeOnly) {
        float minRange = Float.MAX_VALUE;
        class_1309 minEntity = null;
        for (class_1297 entity : ClientMain.mc.field_1687.method_18112()) {
            class_1657 player;
            class_1309 livingEntity;
            if (!(entity instanceof class_1309) || (livingEntity = (class_1309)entity).method_29504() || entity instanceof class_1657 && PlayerUtils.isFriend(player = (class_1657)entity)) continue;
            float distance = entity.method_5739((class_1297)toPlayer);
            if (entity == toPlayer || !(distance <= range) || seeOnly && !toPlayer.method_6057(entity) || !(distance < minRange)) continue;
            minRange = distance;
            minEntity = livingEntity;
        }
        return minEntity;
    }

    public static <T extends class_1297> List<T> findNearestEntities(Class<T> findEntity, class_1657 toPlayer, float range, boolean seeOnly) {
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        for (class_1297 entity : ClientMain.mc.field_1687.method_18112()) {
            class_1657 player;
            if (!findEntity.isAssignableFrom(entity.getClass()) || entity instanceof class_1657 && PlayerUtils.isFriend(player = (class_1657)entity)) continue;
            float distance = entity.method_5739((class_1297)toPlayer);
            if (entity == toPlayer || !(distance <= range) || seeOnly && !toPlayer.method_6057(entity)) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Nullable
    public static class_1799 findShield(class_1657 player) {
        class_1799 result = null;
        for (class_1268 hand : class_1268.values()) {
            class_1799 handStack = player.method_5998(hand);
            if (!handStack.method_31574(class_1802.field_8255)) continue;
            result = handStack;
        }
        return result;
    }

    public static float getShieldCooldownProgress(class_1657 player) {
        class_1799 shieldStack = PlayerUtils.findShield(player);
        if (shieldStack == null) {
            return 0.0f;
        }
        return player.method_7357().method_7905(shieldStack.method_7909(), Utils.getTick());
    }

    public static float getItemCooldownProgress(class_1657 player, class_1799 itemStack) {
        return player.method_7357().method_7905(itemStack.method_7909(), Utils.getTick());
    }

    public static float getItemCooldownProgress(class_1657 player, class_1268 hand) {
        return player.method_7357().method_7905(player.method_5998(hand).method_7909(), Utils.getTick());
    }

    public static float getItemCooldownProgress(class_1268 hand) {
        return ClientMain.mc.field_1724.method_7357().method_7905(ClientMain.mc.field_1724.method_5998(hand).method_7909(), Utils.getTick());
    }

    public static void attackEntity(class_1297 entity) {
        ClientMain.mc.field_1761.method_2918((class_1657)ClientMain.mc.field_1724, entity);
        ClientMain.mc.field_1724.method_6104(class_1268.field_5808);
    }

    public static class_1934 getGameMode(class_1657 player) {
        if (player == null) {
            return null;
        }
        class_640 playerListEntry = ClientMain.mc.method_1562().method_2871(player.method_5667());
        if (playerListEntry == null) {
            return null;
        }
        return playerListEntry.method_2958();
    }

    public static class_239 getHitResult(class_1657 entity, boolean ignoreInvisibles, float yaw, float pitch, double distance) {
        class_238 box;
        class_243 vec3d3;
        class_3966 entityHitResult;
        if (entity == null || ClientMain.mc.field_1687 == null) {
            return null;
        }
        double d = distance;
        class_243 cameraPosVec = entity.method_5836(Utils.getTick());
        class_243 rotationVec = RaycastUtils.getPlayerLookVec(yaw, pitch);
        class_243 range = cameraPosVec.method_1031(rotationVec.field_1352 * d, rotationVec.field_1351 * d, rotationVec.field_1350 * d);
        class_3965 result = ClientMain.mc.field_1687.method_17742(new class_3959(cameraPosVec, range, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)entity));
        double e = d * d;
        d = distance;
        if (result != null) {
            e = result.method_17784().method_1025(cameraPosVec);
        }
        if ((entityHitResult = class_1675.method_18075((class_1297)entity, (class_243)cameraPosVec, (class_243)(vec3d3 = cameraPosVec.method_1031(rotationVec.field_1352 * d, rotationVec.field_1351 * d, rotationVec.field_1350 * d)), (class_238)(box = entity.method_5829().method_18804(rotationVec.method_1021(d)).method_1009(1.0, 1.0, 1.0)), entityx -> !entityx.method_7325() && entityx.method_5863() && (!entityx.method_5767() || !ignoreInvisibles), (double)e)) != null) {
            class_243 vec3d4 = entityHitResult.method_17784();
            double g = cameraPosVec.method_1025(vec3d4);
            if (distance > distance && g > Math.pow(distance, 2.0) || g < e || result == null) {
                result = g > Math.pow(distance, 2.0) ? class_3965.method_17778((class_243)vec3d4, (class_2350)class_2350.method_10142((double)rotationVec.field_1352, (double)rotationVec.field_1351, (double)rotationVec.field_1350), (class_2338)class_2338.method_49638((class_2374)vec3d4)) : entityHitResult;
            }
        }
        return result;
    }

    public static boolean isBlockedByShield(class_1309 attacker, class_1309 shielder, boolean instaBlock) {
        if (attacker == null || shielder == null) {
            return false;
        }
        if (shielder.method_6039() || instaBlock && shielder.method_6030().method_31574(class_1802.field_8255)) {
            class_243 vec3d2 = shielder.method_5828(1.0f);
            class_243 vec3d3 = attacker.method_19538().method_1035(shielder.method_19538());
            vec3d3 = new class_243(vec3d3.field_1352, 0.0, vec3d3.field_1350).method_1029();
            return vec3d3.method_1026(vec3d2) < 0.0;
        }
        return false;
    }
}

