/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.player;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.mixin.IClientPlayerInteractionManagerAccessor;
import net.fabricmc.fabric.utils.player.FindItemResult;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1704;
import net.minecraft.class_1706;
import net.minecraft.class_1707;
import net.minecraft.class_1708;
import net.minecraft.class_1713;
import net.minecraft.class_1714;
import net.minecraft.class_1716;
import net.minecraft.class_1718;
import net.minecraft.class_1722;
import net.minecraft.class_1723;
import net.minecraft.class_1726;
import net.minecraft.class_1728;
import net.minecraft.class_1733;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1828;
import net.minecraft.class_1831;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2680;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3803;
import net.minecraft.class_3858;
import net.minecraft.class_3910;
import net.minecraft.class_3916;
import net.minecraft.class_3971;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public abstract class InventoryUtils {
    private static final Action ACTION = new Action();
    public static int previousSlot = -1;
    public static final int HOTBAR_START = 0;
    public static final int HOTBAR_END = 8;
    public static final int OFFHAND = 40;
    public static final int MAIN_START = 9;
    public static final int MAIN_END = 35;
    public static final int ARMOR_START = 36;
    public static final int ARMOR_END = 39;
    public static Map<class_1738.class_8051, Integer> slotNumByType = new HashMap<class_1738.class_8051, Integer>();

    public static boolean useItem(class_1792 item) {
        class_1661 inventory = ClientMain.mc.field_1724.method_31548();
        for (int i = 0; i <= 8; ++i) {
            if (!inventory.method_5438(i).method_31574(item)) continue;
            inventory.field_7545 = i;
            return true;
        }
        return false;
    }

    public static int find(Class<? extends class_1831> toolClass, boolean hotbar) {
        if (ClientMain.mc.field_1724 == null) {
            return -1;
        }
        class_1661 inventory = ClientMain.mc.field_1724.method_31548();
        int start = hotbar ? 0 : 0;
        int end = hotbar ? 9 : inventory.field_7547.size();
        for (int i = start; i < end; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!(stack.method_7909() instanceof class_1831) || !toolClass.isInstance(stack.method_7909())) continue;
            return i;
        }
        return -1;
    }

    public static boolean swap(class_1792 item) {
        class_1661 inv = ClientMain.mc.field_1724.method_31548();
        for (int i = 0; i <= 8; ++i) {
            if (!inv.method_5438(i).method_31574(item)) continue;
            inv.field_7545 = i;
            return true;
        }
        return false;
    }

    public static boolean hasItem(class_1792 item) {
        class_1661 inv = ClientMain.mc.field_1724.method_31548();
        for (int i = 0; i < 9; ++i) {
            if (!inv.method_5438(i).method_31574(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItemInInv(Predicate<class_1792> item) {
        class_1661 inv = ClientMain.mc.field_1724.method_31548();
        boolean count = false;
        for (int i = 0; i < 36; ++i) {
            class_1799 itemStack = inv.method_5438(i);
            if (!item.test(itemStack.method_7909())) continue;
            return true;
        }
        return false;
    }

    public static Integer findPotion(int slot, int slotto, class_1294 statusEffect) {
        for (int i = slot; i < slotto; ++i) {
            class_1799 itemStack = ClientMain.mc.field_1724.method_31548().method_5438(i);
            if (itemStack.method_7909() != class_1802.field_8436 || statusEffect != null && !InventoryUtils.hasStatusEffect(itemStack, statusEffect)) continue;
            return i;
        }
        return null;
    }

    public static boolean hasStatusEffect(class_1799 itemStack, class_1294 type) {
        if (itemStack.method_7909() instanceof class_1828) {
            for (class_1293 statusEffectInstance : ((class_1844)itemStack.method_57824(class_9334.field_49651)).method_57397()) {
                if (statusEffectInstance.method_5579() != type) continue;
                return true;
            }
        }
        return false;
    }

    public static FindItemResult find(class_1792 ... items) {
        return InventoryUtils.find((class_1799 itemStack) -> {
            for (class_1792 item : items) {
                if (itemStack.method_7909() != item) continue;
                return true;
            }
            return false;
        });
    }

    public static boolean isArmorBetter(class_1799 armorStack) {
        class_1799 currentArmor = ClientMain.mc.field_1724.method_31548().method_7372(slotNumByType.get(((class_1738)armorStack.method_7909()).method_48398()).intValue());
        if (currentArmor == null || !(currentArmor.method_7909() instanceof class_1738)) {
            return true;
        }
        return InventoryUtils.isArmorBetter(currentArmor, armorStack, (class_7225<class_1887>)((class_7225)ClientMain.mc.field_1724.method_56673().method_30530(class_7924.field_41265)));
    }

    public static boolean isArmorBetter(class_1799 fromArmorStack, class_1799 thenArmorStack, class_7225<class_1887> registry) {
        class_1738 fromArmorItem;
        class_1792 class_17922;
        block10: {
            block9: {
                class_17922 = fromArmorStack.method_7909();
                if (!(class_17922 instanceof class_1738)) break block9;
                fromArmorItem = (class_1738)class_17922;
                class_17922 = thenArmorStack.method_7909();
                if (class_17922 instanceof class_1738) break block10;
            }
            return false;
        }
        class_1738 thenArmorItem = (class_1738)class_17922;
        float fromPoints = (float)fromArmorItem.method_7687() + fromArmorItem.method_26353();
        float thenPoints = (float)thenArmorItem.method_7687() + thenArmorItem.method_26353();
        if (fromPoints < thenPoints) {
            return true;
        }
        fromPoints += (float)InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_9111, registry);
        fromPoints += (float)InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_9119, registry);
        thenPoints += (float)InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_9111, registry);
        thenPoints += (float)InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_9119, registry);
        if ((fromPoints += (float)(InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_9101, registry) * 2)) == (thenPoints += (float)(InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_9101, registry) * 2))) {
            switch (fromArmorItem.method_48398()) {
                case field_41934: {
                    fromPoints += (float)InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_9105, registry);
                    fromPoints += (float)InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_9127, registry);
                    thenPoints += (float)InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_9105, registry);
                    thenPoints += (float)InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_9127, registry);
                    break;
                }
                case field_41937: {
                    fromPoints += (float)InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_9128, registry);
                    fromPoints += (float)InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_38223, registry);
                    fromPoints += (float)InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_23071, registry);
                    fromPoints += (float)InventoryUtils.getEnchantmentLevel(fromArmorStack, (class_5321<class_1887>)class_1893.field_9129, registry);
                    thenPoints += (float)InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_9128, registry);
                    thenPoints += (float)InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_38223, registry);
                    thenPoints += (float)InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_23071, registry);
                    thenPoints += (float)InventoryUtils.getEnchantmentLevel(thenArmorStack, (class_5321<class_1887>)class_1893.field_9129, registry);
                }
            }
        }
        return fromPoints < thenPoints;
    }

    public static int getEnchantmentLevel(class_1799 armorStack, class_5321<class_1887> enchantmentKey, class_7225<class_1887> registry) {
        class_6880.class_6883 enchantmentEntry = registry.method_46747(enchantmentKey);
        if (enchantmentEntry != null && class_1890.method_58117((class_1799)armorStack)) {
            return class_1890.method_8225((class_6880)enchantmentEntry, (class_1799)armorStack);
        }
        return 0;
    }

    public static FindItemResult find(Predicate<class_1799> isGood) {
        return InventoryUtils.find(isGood, 0, ClientMain.mc.field_1724.method_31548().method_5439());
    }

    public static FindItemResult find(Predicate<class_1799> isGood, int start, int end) {
        int slot = -1;
        int count = 0;
        for (int i = start; i <= end; ++i) {
            class_1799 stack = ClientMain.mc.field_1724.method_31548().method_5438(i);
            if (!isGood.test(stack)) continue;
            if (slot == -1) {
                slot = i;
            }
            count += stack.method_7947();
        }
        return new FindItemResult(slot, count);
    }

    public static void setInvSlot(int slot) {
        ClientMain.mc.field_1724.method_31548().field_7545 = slot;
        ((IClientPlayerInteractionManagerAccessor)ClientMain.mc.field_1761).callSyncSelectedSlot();
    }

    public static FindItemResult findFastestTool(class_2680 state) {
        float bestScore = -1.0f;
        int slot = -1;
        for (int i = 0; i < 9; ++i) {
            float score = ClientMain.mc.field_1724.method_31548().method_5438(i).method_7924(state);
            if (!(score > bestScore)) continue;
            bestScore = score;
            slot = i;
        }
        return new FindItemResult(slot, 1);
    }

    public static boolean isHolding(class_1792 item) {
        return InventoryUtils.isHolding(item, class_1268.field_5808);
    }

    public static boolean isHolding(class_1792 item, class_1268 hand) {
        return ClientMain.mc.field_1724.method_5998(hand).method_31574(item);
    }

    public static boolean nameContains(String contains) {
        return InventoryUtils.nameContains(contains, class_1268.field_5808);
    }

    public static boolean nameContains(String contains, class_1268 hand) {
        class_1799 item = ClientMain.mc.field_1724.method_5998(hand);
        return item != null && item.method_7922().toLowerCase().contains(contains.toLowerCase());
    }

    public static boolean nameContains(String contains, class_1799 stack) {
        return stack.method_7909().method_7876().toLowerCase().contains(contains.toLowerCase()) && stack.method_7964().getString().contains(contains);
    }

    public static void forEachItem(Consumer<class_1799> run) {
        for (int i = 0; i < 9; ++i) {
            class_1799 item = ClientMain.mc.field_1724.method_31548().method_5438(i);
            if (item == null || item.method_7960()) continue;
            run.accept(item);
        }
    }

    public static class_1799[] getContents() {
        class_1661 inv = ClientMain.mc.field_1724.method_31548();
        class_1799[] stacks = new class_1799[]{};
        for (int i = 0; i < 9; ++i) {
            stacks[i] = inv.method_5438(i);
        }
        return stacks;
    }

    public static void switchItemTo(class_1792 item, class_1268 hand) {
        int slot = InventoryUtils.findItemSlot(item);
        if (slot != -1) {
            InventoryUtils.swap(class_1792.method_7875((int)slot));
            ClientMain.mc.field_1724.method_31548().field_7545 = slot;
            ClientMain.mc.field_1761.method_2906(ClientMain.mc.field_1724.field_7498.field_7763, 36 + slot, 0, class_1713.field_7790, (class_1657)ClientMain.mc.field_1724);
            ClientMain.mc.field_1724.method_6122(hand, ClientMain.mc.field_1724.method_31548().method_5438(slot));
        }
    }

    public static int findItemSlot(class_1792 item) {
        for (int i = 0; i < 36; ++i) {
            class_1799 stack = ClientMain.mc.field_1724.method_31548().method_5438(i);
            if (stack.method_7909() != item) continue;
            return i;
        }
        return -1;
    }

    public static FindItemResult findItemSlot(Predicate<class_1799> predicate) {
        for (int i = 0; i < 36; ++i) {
            class_1799 stack = ClientMain.mc.field_1724.method_31548().method_5438(i);
            if (!predicate.test(stack)) continue;
            return new FindItemResult(i, stack.method_7947());
        }
        return null;
    }

    public static int indexToId(int i) {
        if (ClientMain.mc.field_1724 == null) {
            return -1;
        }
        class_1703 handler = ClientMain.mc.field_1724.field_7512;
        if (handler instanceof class_1723) {
            return InventoryUtils.survivalInventory(i);
        }
        if (handler instanceof class_1707) {
            return InventoryUtils.genericContainer(i, ((class_1707)handler).method_17388());
        }
        if (handler instanceof class_1714) {
            return InventoryUtils.craftingTable(i);
        }
        if (handler instanceof class_3858) {
            return InventoryUtils.furnace(i);
        }
        if (handler instanceof class_3705) {
            return InventoryUtils.furnace(i);
        }
        if (handler instanceof class_3706) {
            return InventoryUtils.furnace(i);
        }
        if (handler instanceof class_1716) {
            return InventoryUtils.generic3x3(i);
        }
        if (handler instanceof class_1718) {
            return InventoryUtils.enchantmentTable(i);
        }
        if (handler instanceof class_1708) {
            return InventoryUtils.brewingStand(i);
        }
        if (handler instanceof class_1728) {
            return InventoryUtils.villager(i);
        }
        if (handler instanceof class_1704) {
            return InventoryUtils.beacon(i);
        }
        if (handler instanceof class_1706) {
            return InventoryUtils.anvil(i);
        }
        if (handler instanceof class_1722) {
            return InventoryUtils.hopper(i);
        }
        if (handler instanceof class_1733) {
            return InventoryUtils.genericContainer(i, 3);
        }
        if (handler instanceof class_3910) {
            return InventoryUtils.cartographyTable(i);
        }
        if (handler instanceof class_3803) {
            return InventoryUtils.grindstone(i);
        }
        if (handler instanceof class_3916) {
            return InventoryUtils.lectern();
        }
        if (handler instanceof class_1726) {
            return InventoryUtils.loom(i);
        }
        if (handler instanceof class_3971) {
            return InventoryUtils.stonecutter(i);
        }
        return -1;
    }

    public static Action click() {
        InventoryUtils.ACTION.type = class_1713.field_7790;
        return ACTION;
    }

    public static Action move() {
        InventoryUtils.ACTION.type = class_1713.field_7790;
        InventoryUtils.ACTION.two = true;
        return ACTION;
    }

    private static int survivalInventory(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 36 + i;
        }
        if (InventoryUtils.isArmor(i)) {
            return 5 + (i - 36);
        }
        return i;
    }

    private static int genericContainer(int i, int rows) {
        if (InventoryUtils.isHotbar(i)) {
            return (rows + 3) * 9 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return rows * 9 + (i - 9);
        }
        return -1;
    }

    private static int craftingTable(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 37 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return i + 1;
        }
        return -1;
    }

    private static int furnace(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 30 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 3 + (i - 9);
        }
        return -1;
    }

    private static int generic3x3(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 36 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return i;
        }
        return -1;
    }

    private static int enchantmentTable(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 29 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 2 + (i - 9);
        }
        return -1;
    }

    private static int brewingStand(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 32 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 5 + (i - 9);
        }
        return -1;
    }

    private static int villager(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 30 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 3 + (i - 9);
        }
        return -1;
    }

    private static int beacon(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 28 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 1 + (i - 9);
        }
        return -1;
    }

    private static int anvil(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 30 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 3 + (i - 9);
        }
        return -1;
    }

    private static int hopper(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 32 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 5 + (i - 9);
        }
        return -1;
    }

    private static int cartographyTable(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 30 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 3 + (i - 9);
        }
        return -1;
    }

    private static int grindstone(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 30 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 3 + (i - 9);
        }
        return -1;
    }

    private static int lectern() {
        return -1;
    }

    private static int loom(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 31 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 4 + (i - 9);
        }
        return -1;
    }

    private static int stonecutter(int i) {
        if (InventoryUtils.isHotbar(i)) {
            return 29 + i;
        }
        if (InventoryUtils.isMain(i)) {
            return 2 + (i - 9);
        }
        return -1;
    }

    public static boolean isHotbar(int i) {
        return i >= 0 && i <= 8;
    }

    public static boolean isMain(int i) {
        return i >= 9 && i <= 35;
    }

    public static boolean isArmor(int i) {
        return i >= 36 && i <= 39;
    }

    static {
        slotNumByType.put(class_1738.class_8051.field_41934, 3);
        slotNumByType.put(class_1738.class_8051.field_41935, 2);
        slotNumByType.put(class_1738.class_8051.field_41936, 1);
        slotNumByType.put(class_1738.class_8051.field_41937, 0);
    }

    public static class Action {
        private class_1713 type = null;
        private boolean two = false;
        private int from = -1;
        private int to = -1;
        private int data = 0;
        private boolean isRecursive = false;

        private Action() {
        }

        public Action fromId(int id) {
            this.from = id;
            return this;
        }

        public Action from(int index) {
            return this.fromId(InventoryUtils.indexToId(index));
        }

        public Action fromHotbar(int i) {
            return this.from(0 + i);
        }

        public Action fromOffhand() {
            return this.from(40);
        }

        public Action fromMain(int i) {
            return this.from(9 + i);
        }

        public Action fromArmor(int i) {
            return this.from(36 + (3 - i));
        }

        public void toId(int id) {
            this.to = id;
            this.run();
        }

        public void to(int index) {
            this.toId(InventoryUtils.indexToId(index));
        }

        public void toHotbar(int i) {
            this.to(0 + i);
        }

        public void toOffhand() {
            this.to(40);
        }

        public void toMain(int i) {
            this.to(9 + i);
        }

        public void toArmor(int i) {
            this.to(36 + (3 - i));
        }

        public void slotId(int id) {
            this.from = this.to = id;
            this.run();
        }

        public void slot(int index) {
            this.slotId(InventoryUtils.indexToId(index));
        }

        public void slotHotbar(int i) {
            this.slot(0 + i);
        }

        public void slotOffhand() {
            this.slot(40);
        }

        public void slotMain(int i) {
            this.slot(9 + i);
        }

        public void slotArmor(int i) {
            this.slot(36 + (3 - i));
        }

        public void run() {
            boolean hadEmptyCursor = ClientMain.mc.field_1724.field_7512.method_34255().method_7960();
            if (this.type != null && this.from != -1 && this.to != -1) {
                this.click(this.from);
                if (this.two) {
                    this.click(this.to);
                }
            }
            class_1713 preType = this.type;
            boolean preTwo = this.two;
            int preFrom = this.from;
            int preTo = this.to;
            this.type = null;
            this.two = false;
            this.from = -1;
            this.to = -1;
            this.data = 0;
            if (!this.isRecursive && hadEmptyCursor && preType == class_1713.field_7790 && preTwo && preFrom != -1 && preTo != -1 && !ClientMain.mc.field_1724.field_7512.method_34255().method_7960()) {
                this.isRecursive = true;
                InventoryUtils.click().slotId(preFrom);
                this.isRecursive = false;
            }
        }

        private void click(int id) {
            ClientMain.mc.field_1761.method_2906(ClientMain.mc.field_1724.field_7512.field_7763, id, this.data, this.type, (class_1657)ClientMain.mc.field_1724);
        }
    }
}

