/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.math;

import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.managers.rotation.Rotation;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class MathUtil {
    public static int compareDist(class_1297 entityA, class_1297 entityB) {
        return Float.compare(entityA.method_5739((class_1297)ClientMain.mc.field_1724), entityB.method_5739((class_1297)ClientMain.mc.field_1724));
    }

    public static Rotation getDir(class_1297 entity, class_243 vec) {
        double dx = vec.field_1352 - entity.method_23317();
        double dy = vec.field_1351 - entity.method_23318();
        double dz = vec.field_1350 - entity.method_23321();
        double dist = class_3532.method_15355((float)((float)(dx * dx + dz * dz)));
        return new Rotation((float)class_3532.method_15338((double)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0)), (float)(-class_3532.method_15338((double)Math.toDegrees(Math.atan2(dy, dist)))));
    }

    public static boolean isInFOV(class_1297 entity, double angle) {
        angle *= 0.5;
        if (entity != null) {
            double angleDiff = MathUtil.getAngleDifference(ClientMain.mc.field_1724.method_36454(), MathUtil.getRotations(entity)[0]);
            return angleDiff > 0.0 && angleDiff < angle || -angle < angleDiff && angleDiff < 0.0 && entity != null;
        }
        return false;
    }

    public static float getAngleDifference(float dir, float yaw) {
        float f;
        float dist = f = Math.abs(yaw - dir) % 360.0f;
        if (f > 180.0f) {
            dist = 360.0f - f;
        }
        return dist;
    }

    public static float[] getRotations(class_1297 ent) {
        double x = ent.method_19538().method_10216();
        double y = ent.method_19538().method_10214() + (double)ent.method_18381(ent.method_18376());
        double z = ent.method_19538().method_10215();
        return MathUtil.getRotationFromPosition(x, y, z);
    }

    public static float[] getRotationFromPosition(double x, double y, double z) {
        double xDiff = x - ClientMain.mc.field_1724.method_19538().method_10216();
        double yDiff = y - (ClientMain.mc.field_1724.method_19538().method_10214() + (double)ClientMain.mc.field_1724.method_18381(ClientMain.mc.field_1724.method_18376()));
        double zDiff = z - ClientMain.mc.field_1724.method_19538().method_10215();
        double dist = class_3532.method_39241((double)xDiff, (double)zDiff);
        float yaw = (float)(Math.atan2(zDiff, xDiff) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(yDiff, dist) * 180.0 / Math.PI));
        return new float[]{yaw, pitch};
    }

    public static float[] getNeededRotations(class_243 vec) {
        class_243 eyesPos = ClientMain.mc.field_1724.method_33571();
        double diffX = vec.field_1352 - eyesPos.field_1352;
        double diffY = vec.field_1351 - eyesPos.field_1351;
        double diffZ = vec.field_1350 - eyesPos.field_1350;
        double diffXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
        float yaw = (float)Math.toDegrees(Math.atan2(diffZ, diffX)) - 90.0f;
        float pitch = (float)(-Math.toDegrees(Math.atan2(diffY, diffXZ)));
        return new float[]{class_3532.method_15393((float)yaw), class_3532.method_15393((float)pitch)};
    }

    public static double goodLerp(float delta, double start, double end) {
        int step = (int)Math.ceil(Math.abs(end - start) * (double)delta);
        if (start < end) {
            return Math.min(start + (double)step, end);
        }
        return Math.max(start - (double)step, end);
    }

    public static float lerp(float start, float end, float alpha) {
        return start + (end - start) * alpha;
    }

    public static double getAngleToLookVec(class_243 vec) {
        float[] needed = MathUtil.getNeededRotations(vec);
        float currentYaw = class_3532.method_15393((float)ClientMain.mc.field_1724.method_36454());
        float currentPitch = class_3532.method_15393((float)ClientMain.mc.field_1724.method_36455());
        float diffYaw = currentYaw - needed[0];
        float diffPitch = currentPitch - needed[1];
        return Math.hypot(diffYaw, diffPitch);
    }

    public static float angleDiff(float a, float b) {
        float diff = ((b - a + 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f;
        return Math.abs(diff);
    }

    public static int getRandomInt(int from, int to) {
        if (from >= to) {
            return from;
        }
        return ThreadLocalRandom.current().nextInt(from, to + 1);
    }

    public static double getRandomDouble(double from, double to) {
        if (from >= to) {
            return from;
        }
        return ThreadLocalRandom.current().nextDouble(from, to);
    }

    public static double wrapAngleTo180(double angle) {
        return ((angle + 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
    }
}

