/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.utils.font;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.utils.font.Font;
import net.fabricmc.fabric.utils.render.ColorUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5611;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.apache.commons.codec.binary.Base64;
import org.joml.Matrix4f;

public class FontRenderer {
    private static final Map<Font, FontRenderer> fonts = new HashMap<Font, FontRenderer>();
    private java.awt.Font theFont;
    private Graphics2D theGraphics;
    private FontMetrics theMetrics;
    private float fontSize;
    private int startChar;
    private int endChar;
    private float[] xPos;
    private float[] yPos;
    public BufferedImage bufferedImage;
    public class_2960 resourceLocation;
    private final Pattern patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OG]");
    private final Pattern patternUnsupported = Pattern.compile("(?i)\\u00A7[L-O]");
    private class_2960 fontPath;
    private static final class_310 mc = class_310.method_1551();

    public static void registerFont(Font font, class_2960 fontPath, float size) {
        fonts.put(font, new FontRenderer(fontPath, size));
    }

    public static FontRenderer getFontRenderer(Font name) {
        return fonts.get((Object)name);
    }

    public FontRenderer(class_2960 fontPath, float size) {
        this(null, fontPath, size);
    }

    public FontRenderer(Object font, class_2960 fontPath, float size) {
        this.fontPath = fontPath;
        this.fontSize = size;
        this.startChar = 32;
        this.endChar = 255;
        this.xPos = new float[this.endChar - this.startChar];
        this.yPos = new float[this.endChar - this.startChar];
        this.setupGraphics2D();
        this.createFont(font, size, fontPath);
    }

    private void setupGraphics2D() {
        this.bufferedImage = new BufferedImage(256, 256, 2);
        this.theGraphics = (Graphics2D)this.bufferedImage.getGraphics();
        this.theGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    private void createFont(Object font, float size, class_2960 fontPath) {
        try {
            if (font instanceof java.awt.Font) {
                this.theFont = ((java.awt.Font)font).deriveFont(size);
            } else if (font instanceof File) {
                this.theFont = java.awt.Font.createFont(0, (File)font).deriveFont(size);
            } else if (font instanceof InputStream) {
                this.theFont = java.awt.Font.createFont(0, (InputStream)font).deriveFont(size);
            } else if (font instanceof class_2960) {
                this.theFont = this.loadFontFromIdentifier((class_2960)font, size);
            } else if (font instanceof String) {
                class_2960 actualFontPath = class_2960.method_60655((String)fontPath.method_12836(), (String)(fontPath.method_12832() + "/" + String.valueOf(font)));
                this.theFont = this.loadFontFromIdentifier(actualFontPath, size);
            } else {
                this.theFont = this.loadFontFromIdentifier(fontPath, size);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.theFont = new java.awt.Font("Verdana", 0, Math.round(size));
        }
        this.theGraphics.setFont(this.theFont);
        this.setupFontMetrics(size);
    }

    private java.awt.Font loadFontFromIdentifier(class_2960 id, float size) throws Exception {
        String path = "/assets/" + id.method_12836() + "/" + id.method_12832();
        try (InputStream stream = FontRenderer.class.getResourceAsStream(path);){
            if (stream == null) {
                java.awt.Font font = new java.awt.Font("Verdana", 0, Math.round(size));
                return font;
            }
            java.awt.Font font = java.awt.Font.createFont(0, stream).deriveFont(size);
            return font;
        }
    }

    private void setupFontMetrics(float size) {
        this.theGraphics.setColor(new Color(255, 255, 255, 0));
        this.theGraphics.fillRect(0, 0, 256, 256);
        this.theGraphics.setColor(Color.white);
        this.theMetrics = this.theGraphics.getFontMetrics();
        float x = 5.0f;
        float y = 5.0f;
        for (int i = this.startChar; i < this.endChar; ++i) {
            this.theGraphics.drawString(Character.toString((char)i), x, y + (float)this.theMetrics.getAscent());
            this.xPos[i - this.startChar] = x;
            this.yPos[i - this.startChar] = y - (float)this.theMetrics.getMaxDescent();
            x += (float)this.theMetrics.stringWidth(Character.toString((char)i)) + 2.0f;
            if (!(x >= (float)(250 - this.theMetrics.getMaxAdvance()))) continue;
            x = 5.0f;
            y += (float)(this.theMetrics.getMaxAscent() + this.theMetrics.getMaxDescent()) + size / 2.0f;
        }
        String base64 = this.imageToBase64String(this.bufferedImage, "png");
        this.setResourceLocation(base64, this.theFont, this.fontPath, size);
    }

    private String imageToBase64String(BufferedImage image, String type) {
        String ret = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, type, bos);
            byte[] bytes = bos.toByteArray();
            Base64 encoder = new Base64();
            ret = encoder.encodeAsString(bytes);
            ret = ret.replace(System.lineSeparator(), "");
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return ret;
    }

    private void setResourceLocation(String base64, Object font, class_2960 identifier, float size) {
        class_1011 image = FontRenderer.readTexture(base64);
        if (image == null) {
            return;
        }
        int imageWidth = image.method_4307();
        int imageHeight = image.method_4323();
        class_1011 imgNew = new class_1011(imageWidth, imageHeight, true);
        for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4323(); ++y) {
                imgNew.method_4305(x, y, image.method_4315(x, y));
            }
        }
        image.close();
        this.resourceLocation = class_2960.method_60655((String)identifier.method_12836(), (String)(identifier.method_12832() + this.getFont().getFontName().toLowerCase().replace(" ", "-") + size));
        this.applyTexture(this.resourceLocation, imgNew);
    }

    private static class_1011 readTexture(String textureBase64) {
        try {
            byte[] imgBytes = Base64.decodeBase64((String)textureBase64);
            ByteArrayInputStream bais = new ByteArrayInputStream(imgBytes);
            return class_1011.method_4309((InputStream)bais);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void applyTexture(class_2960 identifier, class_1011 nativeImage) {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(identifier, (class_1044)new class_1043(nativeImage)));
    }

    public void drawString(class_4587 matrixStack, String text, double x, double y, int color, boolean b) {
        this.drawString(matrixStack, text, (float)x, (float)y, FontType.NORMAL, color);
    }

    public void drawString(class_4587 matrixStack, class_327 textRenderer, String text, float x, float y, int color) {
        this.drawString(matrixStack, text, x, y - 10.0f, FontType.NORMAL, color);
    }

    public void drawString(class_4587 matrixStack, String text, float x, float y, FontType fontType, int color, int color2) {
        text = this.stripUnsupported(text);
        Renderer.setup2DRender(false);
        String text2 = this.stripControlCodes(text);
        switch (fontType.ordinal()) {
            case 1: {
                this.drawer(matrixStack, text2, x + 0.5f, y, color2);
                this.drawer(matrixStack, text2, x - 0.5f, y, color2);
                this.drawer(matrixStack, text2, x, y + 0.5f, color2);
                this.drawer(matrixStack, text2, x, y - 0.5f, color2);
                break;
            }
            case 2: {
                this.drawer(matrixStack, text2, x + 0.5f, y + 0.5f, color2);
                break;
            }
            case 3: {
                this.drawer(matrixStack, text2, x + 0.5f, y + 1.0f, color2);
                break;
            }
            case 4: {
                this.drawer(matrixStack, text2, x, y + 0.5f, color2);
                break;
            }
            case 5: {
                this.drawer(matrixStack, text2, x, y - 0.5f, color2);
                break;
            }
        }
        this.drawer(matrixStack, text, x, y, color);
        Renderer.end2DRender();
    }

    public void drawString(class_4587 matrixStack, String text, float x, float y, FontType fontType, int color) {
        matrixStack.method_22905(0.5f, 0.5f, 1.0f);
        this.drawString(matrixStack, text, x, y, fontType, color, -1157627904);
        matrixStack.method_22905(2.0f, 2.0f, 1.0f);
    }

    private void drawer(class_4587 matrices, String text, float x, float y, int color) {
        x *= 2.0f;
        y *= 2.0f;
        Renderer.setup2DRender(false);
        Renderer.bindTexture(this.resourceLocation);
        if ((color & 0xFF000000) == 0) {
            color |= 0xFF000000;
        }
        float startX = x;
        boolean scramble = false;
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        RenderSystem.setShader(class_757::method_34543);
        int vertexCount = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7' && i + 1 < text.length()) {
                char formatChar = Character.toLowerCase(text.charAt(i + 1));
                switch (formatChar) {
                    case 'n': {
                        y += (float)(this.theMetrics.getAscent() + 2);
                        x = startX;
                        break;
                    }
                    case 'k': {
                        scramble = true;
                        break;
                    }
                    case 'r': {
                        color = color & 0xFF000000 | 0xFFFFFF;
                        break;
                    }
                    default: {
                        int newColor = this.getColorFromCode(formatChar);
                        if (newColor == -1) break;
                        color = newColor;
                    }
                }
                ++i;
                continue;
            }
            if (scramble) {
                String obfChars = "\\:><&%$@!?/";
                c = obfChars.charAt((int)(Math.random() * (double)obfChars.length()));
            }
            Rectangle2D bounds = this.theMetrics.getStringBounds(Character.toString(c), this.theGraphics);
            float charWidth = (float)bounds.getWidth();
            float charHeight = (float)bounds.getHeight() + (float)this.theMetrics.getMaxDescent() + 1.0f;
            if (c < this.startChar || c >= this.startChar + this.xPos.length) continue;
            float u = this.xPos[c - this.startChar];
            float v = this.yPos[c - this.startChar];
            float scale = 0.0039063f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            Matrix4f matrix = matrices.method_23760().method_23761();
            bufferBuilder.method_22918(matrix, x, y + charHeight, 0.0f).method_22913(u * scale, (v + charHeight) * scale).method_22915(r, g, b, a);
            bufferBuilder.method_22918(matrix, x + charWidth, y + charHeight, 0.0f).method_22913((u + charWidth) * scale, (v + charHeight) * scale).method_22915(r, g, b, a);
            bufferBuilder.method_22918(matrix, x + charWidth, y, 0.0f).method_22913((u + charWidth) * scale, v * scale).method_22915(r, g, b, a);
            bufferBuilder.method_22918(matrix, x, y, 0.0f).method_22913(u * scale, v * scale).method_22915(r, g, b, a);
            vertexCount += 4;
            x += this.getStringWidth(Character.toString(c), false) * 2.0f;
        }
        if (vertexCount > 0) {
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
        Renderer.shaderColor(-1);
    }

    private void drawChar(class_4587 matrixStack, char character, float x, float y, int color) throws ArrayIndexOutOfBoundsException {
        Rectangle2D bounds = this.theMetrics.getStringBounds(Character.toString(character), this.theGraphics);
        this.drawTexturedModalRect(matrixStack, x, y, this.xPos[character - this.startChar], this.yPos[character - this.startChar], (float)bounds.getWidth(), (float)bounds.getHeight() + (float)this.theMetrics.getMaxDescent() + 1.0f, color);
    }

    private void drawTexturedModalRect(class_4587 matrixStack, float x, float y, float u, float v, float width, float height, int color) {
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        float scale = 0.0039063f;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        bufferBuilder.method_22918(matrix4f, x + 0.0f, y + height, 0.0f).method_22913((u + 0.0f) * scale, (v + height) * scale).method_22915(f1, f2, f3, f);
        bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_22913((u + width) * scale, (v + height) * scale).method_22915(f1, f2, f3, f);
        bufferBuilder.method_22918(matrix4f, x + width, y + 0.0f, 0.0f).method_22913((u + width) * scale, (v + 0.0f) * scale).method_22915(f1, f2, f3, f);
        bufferBuilder.method_22918(matrix4f, x + 0.0f, y + 0.0f, 0.0f).method_22913((u + 0.0f) * scale, (v + 0.0f) * scale).method_22915(f1, f2, f3, f);
    }

    private String wrapFormattedStringToWidth(String s, float width) {
        int wrapWidth = this.sizeStringToWidth(s, width);
        if (s.length() <= wrapWidth) {
            return s;
        }
        String split = s.substring(0, wrapWidth);
        String split2 = this.getFormatFromString(split) + s.substring(wrapWidth + (s.charAt(wrapWidth) == ' ' || s.charAt(wrapWidth) == '\n' ? 1 : 0));
        try {
            return split + "\n" + this.wrapFormattedStringToWidth(split2, width);
        }
        catch (Exception e) {
            System.err.println("Cannot wrap string to width.");
            return "";
        }
    }

    private int sizeStringToWidth(String par1Str, float par2) {
        int var5;
        int var3 = par1Str.length();
        float var4 = 0.0f;
        int var6 = -1;
        boolean var7 = false;
        for (var5 = 0; var5 < var3; ++var5) {
            char var8 = par1Str.charAt(var5);
            switch (var8) {
                case '\n': {
                    --var5;
                    break;
                }
                case '\u00a7': {
                    char var9;
                    if (var5 >= var3 - 1) break;
                    if ((var9 = par1Str.charAt(++var5)) != 'l' && var9 != 'L') {
                        if (var9 != 'r' && var9 != 'R' && !this.isFormatColor(var9)) break;
                        var7 = false;
                        break;
                    }
                    var7 = true;
                    break;
                }
                case ' ': {
                    var6 = var5;
                }
                case '-': {
                    var6 = var5;
                }
                case '_': {
                    var6 = var5;
                }
                case ':': {
                    var6 = var5;
                }
                default: {
                    String text = String.valueOf(var8);
                    var4 += this.getStringWidth(text, false);
                    if (!var7) break;
                    var4 += 1.0f;
                }
            }
            if (var8 == '\n') {
                var6 = ++var5;
                continue;
            }
            if (var4 > par2) break;
        }
        return var5 != var3 && var6 != -1 && var6 < var5 ? var6 : var5;
    }

    private String getFormatFromString(String par0Str) {
        Object var1 = "";
        int var2 = -1;
        int var3 = par0Str.length();
        while ((var2 = par0Str.indexOf(167, var2 + 1)) != -1) {
            if (var2 >= var3 - 1) continue;
            char var4 = par0Str.charAt(var2 + 1);
            if (this.isFormatColor(var4)) {
                var1 = "\u00a7" + var4;
                continue;
            }
            if (!this.isFormatSpecial(var4)) continue;
            var1 = (String)var1 + "\u00a7" + var4;
        }
        return var1;
    }

    private boolean isFormatColor(char par0) {
        return par0 >= '0' && par0 <= '9' || par0 >= 'a' && par0 <= 'f' || par0 >= 'A' && par0 <= 'F';
    }

    private boolean isFormatSpecial(char par0) {
        return par0 >= 'k' && par0 <= 'o' || par0 >= 'K' && par0 <= 'O' || par0 == 'r' || par0 == 'R';
    }

    public void drawGradient(class_332 drawContext, String text, int x, int y, int spaceBetweenLetters, Color firstColor, Color secondColor, Font fonttype, boolean vertical) {
        float charX = x;
        FontRenderer font = fonts.get((Object)fonttype);
        if (font == null) {
            return;
        }
        for (char c : text.toCharArray()) {
            String string = String.valueOf(c);
            class_5611 position = vertical ? new class_5611(0.0f, charX * 80.0f) : new class_5611(charX * 80.0f, 0.0f);
            Color color = ColorUtil.getAccentColor(position, firstColor, secondColor);
            font.drawString(drawContext.method_51448(), string, (double)((int)charX), (double)y, color.getRGB(), true);
            charX += font.getWidth(string) + (float)spaceBetweenLetters;
        }
    }

    public final String stripControlCodes(String s) {
        return this.patternControlCode.matcher(s).replaceAll("");
    }

    public final String stripUnsupported(String s) {
        return this.patternUnsupported.matcher(s).replaceAll("");
    }

    public final java.awt.Font getFont() {
        return this.theFont;
    }

    private int getColorFromCode(char code) {
        return switch (code) {
            case '0' -> Color.BLACK.getRGB();
            case '1' -> -16777046;
            case '2' -> -16733696;
            case '3' -> -16733526;
            case '4' -> -5636096;
            case '5' -> -5635926;
            case '6' -> -22016;
            case '7' -> -5592406;
            case '8' -> -11184811;
            case '9' -> -11184641;
            case 'a' -> -11141291;
            case 'b' -> -11141121;
            case 'c' -> -43691;
            case 'd' -> -43521;
            case 'e' -> -171;
            case 'f' -> -1;
            case 'g' -> -2238971;
            default -> -1;
        };
    }

    public float getStringWidth(String string, boolean mcFont) {
        if (!mcFont) {
            return (float)this.getBounds(this.stripControlCodes(string)).getWidth() / 2.0f;
        }
        return FontRenderer.mc.field_1772.method_1727(string);
    }

    public FontRenderer getCurrentFont(Font font) {
        return FontRenderer.getFontRenderer(font);
    }

    public float getWidth(String s) {
        return this.getStringWidth(s, false);
    }

    private Rectangle2D getBounds(String text) {
        return this.theMetrics.getStringBounds(text, this.theGraphics);
    }

    public float getStringHeight(String string, boolean mcFont) {
        if (!mcFont) {
            return (float)(this.getBounds(this.stripControlCodes(string)).getHeight() / 2.0);
        }
        Objects.requireNonNull(FontRenderer.mc.field_1772);
        return 9.0f;
    }

    public float getStringWidth(class_2561 string) {
        return FontRenderer.mc.field_1772.method_27525((class_5348)string);
    }

    public void draw(class_4587 matrixStack, String text, float x, float y, int color) {
        this.drawString(matrixStack, text, x, y + 2.0f, FontType.NORMAL, color);
    }

    public void draw(class_4587 matrixStack, String text1, String text2, float x, float y, Color color1, Color color2) {
        this.drawString(matrixStack, text1, x, y + 2.0f, FontType.NORMAL, color1.getRGB());
        float text1Width = this.getWidth(text1);
        this.drawString(matrixStack, text2, x + text1Width, y + 2.0f, FontType.NORMAL, color2.getRGB());
    }

    public void drawCenteredString(class_4587 matrixStack, String string, float x, float y, int color, boolean shadow, boolean mcFont) {
        float newX = x - this.getStringWidth(string, mcFont) / 2.0f;
        this.drawString(matrixStack, string, newX, y, shadow ? FontType.SHADOW_THIN : FontType.NORMAL, color);
    }

    public void draw(class_4587 matrices, String text, float x, float y, Color color, Font fontName) {
        FontRenderer font = fonts.get((Object)fontName);
        if (font == null) {
            throw new IllegalArgumentException("Font " + String.valueOf((Object)fontName) + " is not registered!");
        }
        font.drawString(matrices, text, (double)x, (double)y, color.getRGB(), false);
    }

    public void drawWithShadow(class_4587 matrixStack, class_2561 text, float x, float y, int color, boolean mcFont) {
        String s = text.getString();
        this.draw(matrixStack, s, x + 0.5f, y + 0.5f + 4.0f, -16777216);
        this.draw(matrixStack, s, x, y, color);
    }

    public void drawCenteredString(class_4587 matrixStack, class_2561 string, float x, float y, int color, boolean mcFont) {
        float newX = x - this.getStringWidth(string) / 2.0f;
        this.drawWithShadow(matrixStack, string, newX, y, color, mcFont);
    }

    public String fix(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        for (int i = 0; i < 9; ++i) {
            if (!s.contains("\u00a7" + i)) continue;
            s = s.replace("\u00a7" + i, "");
        }
        return s.replace("\u00a7a", "").replace("\u00a7b", "").replace("\u00a7c", "").replace("\u00a7d", "").replace("\u00a7e", "").replace("\u00a7f", "").replace("\u00a7g", "");
    }

    public String trimToWidth(String string, int width) {
        try {
            return string.substring(0, width);
        }
        catch (Exception e) {
            return string;
        }
    }

    public String trimToWidth(String string, int width, boolean backwards) {
        try {
            return backwards ? string.substring(width) : string.substring(0, width);
        }
        catch (Exception e) {
            return string;
        }
    }

    public static Font getFont(String name) {
        if (name == null) {
            return null;
        }
        switch (name.toLowerCase()) {
            case "verdana": {
                return Font.VERDANA;
            }
            case "verdanabold": {
                return Font.VERDANABOLD;
            }
            case "robotobold": {
                return Font.ROBOTOBOLD;
            }
        }
        return null;
    }

    public static enum FontType {
        NORMAL,
        SHADOW_THICK,
        SHADOW_THIN,
        OUTLINE_THIN,
        EMBOSS_TOP,
        EMBOSS_BOTTOM;

    }

    private static class Renderer {
        private Renderer() {
        }

        public static void setup2DRender(boolean disableDepth) {
            RenderSystem.enableBlend();
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            if (disableDepth) {
                RenderSystem.disableDepthTest();
            }
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public static void end2DRender() {
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }

        public static void bindTexture(class_2960 identifier) {
            RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
        }

        public static void shaderColor(int rgb) {
            float alpha = (float)(rgb >> 24 & 0xFF) / 255.0f;
            float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float blue = (float)(rgb & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        }
    }
}

