/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.systems.module.impl.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.gui.setting.BooleanSetting;
import net.fabricmc.fabric.gui.setting.ColorPickerSetting;
import net.fabricmc.fabric.gui.setting.ModeSetting;
import net.fabricmc.fabric.systems.module.core.Category;
import net.fabricmc.fabric.systems.module.core.Module;
import net.fabricmc.fabric.utils.render.ColorUtil;
import net.fabricmc.fabric.utils.render.Render2DEngine;
import net.fabricmc.fabric.utils.render.Render3DEngine;
import net.fabricmc.fabric.utils.world.BlockUtils;
import net.fabricmc.fabric.utils.world.WorldUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;

public class BlockESP
extends Module {
    ModeSetting mode = new ModeSetting("m".concat("^").concat("o").concat("@").concat("d").concat("$").concat("e"), "O".concat("#").concat("u").concat("(").concat("t").concat("#").concat("l").concat("@").concat("i").concat("@").concat("n").concat("&").concat("e"), "R".concat("#").concat("e").concat("^").concat("n").concat(")").concat("d").concat("&").concat("e").concat("#").concat("r").concat("@").concat(" ").concat("&").concat("m").concat("&").concat("o").concat("&").concat("d").concat("-").concat("e"), "F".concat("-").concat("i").concat("-").concat("l").concat("#").concat("l").concat("!").concat("e").concat("(").concat("d").concat(")").concat(" ").concat("+").concat("b").concat("$").concat("o").concat("$").concat("x"), "O".concat("(").concat("u").concat("#").concat("t").concat(")").concat("l").concat("_").concat("i").concat("*").concat("n").concat("!").concat("e"));
    public BooleanSetting showNames = new BooleanSetting("s".concat(")").concat("h").concat("+").concat("o").concat(")").concat("w").concat("-").concat("N").concat("^").concat("a").concat("!").concat("m").concat("_").concat("e").concat("_").concat("s"), true, "S".concat("&").concat("h").concat("!").concat("o").concat("_").concat("w").concat("!").concat("s").concat("&").concat(" ").concat("#").concat("b").concat("@").concat("l").concat("+").concat("o").concat("#").concat("c").concat("-").concat("k").concat("&").concat(" ").concat("!").concat("n").concat("-").concat("a").concat("_").concat("m").concat("@").concat("e").concat("#").concat("s"));
    public ColorPickerSetting blockColor = new ColorPickerSetting("b".concat("*").concat("l").concat("*").concat("o").concat("_").concat("c").concat("+").concat("k").concat("$").concat("C").concat("+").concat("o").concat("$").concat("l").concat("_").concat("o").concat("^").concat("r"), new Color(255, 0, 0, 255), "C".concat("#").concat("o").concat("*").concat("l").concat("+").concat("o").concat(")").concat("r").concat("(").concat(" ").concat(")").concat("o").concat("$").concat("f").concat("&").concat(" ").concat("(").concat("t").concat("#").concat("h").concat("@").concat("e").concat("-").concat(" ").concat("!").concat("b").concat(")").concat("l").concat("!").concat("o").concat("$").concat("c").concat("(").concat("k").concat("^").concat("s"));
    public ModeSetting blocks = new ModeSetting("B".concat(")").concat("l").concat("^").concat("o").concat(")").concat("c").concat("&").concat("k").concat(")").concat("s"), "S".concat(")").concat("t").concat("&").concat("o").concat("&").concat("r").concat("&").concat("a").concat("(").concat("g").concat("^").concat("e"), "B".concat("#").concat("l").concat("^").concat("o").concat("#").concat("c").concat("(").concat("k").concat("$").concat("s").concat("&").concat(" ").concat(")").concat("t").concat("$").concat("o").concat("(").concat(" ").concat(")").concat("h").concat("-").concat("i").concat("-").concat("g").concat("*").concat("h").concat("&").concat("l").concat("-").concat("i").concat("!").concat("g").concat("-").concat("h").concat("@").concat("t"), "O".concat("_").concat("r").concat("-").concat("e").concat("!").concat("s"), "S".concat(")").concat("t").concat("(").concat("o").concat("^").concat("r").concat("*").concat("a").concat(")").concat("g").concat("!").concat("e"), "B".concat("+").concat("o").concat("#").concat("t").concat("*").concat("h"));
    public BooleanSetting onlyVisible = new BooleanSetting("O".concat("&").concat("n").concat("(").concat("l").concat("*").concat("y").concat("_").concat(" ").concat("^").concat("V").concat("&").concat("i").concat("$").concat("s").concat("!").concat("i").concat("^").concat("b").concat("#").concat("l").concat("_").concat("e"), true, "O".concat("(").concat("n").concat("$").concat("l").concat("!").concat("y").concat("+").concat(" ").concat("+").concat("h").concat(")").concat("i").concat("$").concat("g").concat(")").concat("h").concat("(").concat("l").concat("!").concat("i").concat("$").concat("g").concat("_").concat("h").concat("^").concat("t").concat("(").concat("s").concat("#").concat(" ").concat("_").concat("v").concat(")").concat("i").concat("(").concat("s").concat(")").concat("i").concat("(").concat("b").concat("$").concat("l").concat("@").concat("e").concat("*").concat(" ").concat("@").concat("o").concat("!").concat("r").concat(")").concat("e").concat("!").concat("s"));
    private List<class_2248> blocksToHighlightOres = Arrays.asList(class_2246.field_10418, class_2246.field_29219, class_2246.field_10212, class_2246.field_29027, class_2246.field_27120, class_2246.field_29221, class_2246.field_10571, class_2246.field_29026, class_2246.field_10080, class_2246.field_29030, class_2246.field_10090, class_2246.field_29028, class_2246.field_10442, class_2246.field_29029, class_2246.field_10013, class_2246.field_29220, class_2246.field_23077, class_2246.field_10213, class_2246.field_22109);
    private List<class_2248> blocksToHighlight = Arrays.asList(class_2246.field_10181, class_2246.field_16333, class_2246.field_16334, class_2246.field_10034, class_2246.field_10380, class_2246.field_16328, class_2246.field_10200, class_2246.field_10228, class_2246.field_10312, class_2246.field_10603, class_2246.field_10199, class_2246.field_10407, class_2246.field_10063, class_2246.field_10203, class_2246.field_10600, class_2246.field_10275, class_2246.field_10051, class_2246.field_10140, class_2246.field_10320, class_2246.field_10532, class_2246.field_10268, class_2246.field_10605, class_2246.field_10373, class_2246.field_10055, class_2246.field_10068, class_2246.field_10371, class_2246.field_10443, class_2246.field_10260, class_2246.field_10327, class_2246.field_10223, class_2246.field_10485, class_2246.field_10333, class_2246.field_17350, class_2246.field_23860, class_2246.field_16332, class_2246.field_10502, class_2246.field_10525, class_2246.field_10263, class_2246.field_10395, class_2246.field_10429, class_2246.field_28108, class_2246.field_37570, class_2246.field_37571, class_2246.field_16330, class_2246.field_10560, class_2246.field_10008, class_2246.field_10465, class_2246.field_16540, class_2246.field_40277, class_2246.field_40271);

    public BlockESP() {
        super("B".concat("(").concat("l").concat("^").concat("o").concat("(").concat("c").concat("+").concat("k").concat("#").concat("E").concat("(").concat("S").concat("-").concat("P"), "H".concat("-").concat("i").concat("!").concat("g").concat("-").concat("h").concat(")").concat("l").concat(")").concat("i").concat("^").concat("g").concat("&").concat("h").concat("-").concat("t").concat("&").concat("s").concat("#").concat(" ").concat("$").concat("b").concat("_").concat("l").concat("(").concat("o").concat("^").concat("c").concat("^").concat("k").concat("&").concat("s"), Category.Render);
        this.addSettings(this.mode, this.showNames, this.onlyVisible, this.blocks, this.blockColor);
    }

    @Override
    public void onWorldRender(class_4587 matrices) {
        if (!this.isEnabled()) {
            return;
        }
        CompletableFuture<List<class_3545<class_2338, class_2248>>> futureOreBlocks = BlockUtils.getOreBlocksAsync();
        BlockESP.getLoadedChunks().forEach(chunk -> chunk.method_12214().values().forEach(blockEntity -> {
            class_2248 block = blockEntity.method_11010().method_26204();
            class_2338 pos = blockEntity.method_11016();
            if ((this.blocks.isMode("Storage") || this.blocks.isMode("Both")) && this.blocksToHighlight.contains(block)) {
                if (this.mode.isMode("Outline")) {
                    this.drawHighlightOutline(matrices, pos);
                } else if (this.mode.isMode("Filled box")) {
                    Color newBlockColor = ColorUtil.addAlpha(this.blockColor.getColor(), 128);
                    Render3DEngine.drawBoxWithParams(class_243.method_24953((class_2382)pos).method_1031(0.0, -0.5, 0.0), newBlockColor, matrices, 0.5f, 1.0f);
                }
            }
        }));
        if (this.blocks.isMode("Ores") || this.blocks.isMode("Both")) {
            futureOreBlocks.thenAccept(oreBlocks -> {
                for (class_3545 pair : oreBlocks) {
                    if (!this.blocksToHighlightOres.contains(pair.method_15441())) continue;
                    class_2338 pos = (class_2338)pair.method_15442();
                    if (this.mode.isMode("Outline")) {
                        this.drawHighlightOutline(matrices, pos);
                        continue;
                    }
                    if (!this.mode.isMode("Filled box")) continue;
                    Color newBlockColor = ColorUtil.addAlpha(this.blockColor.getColor(), 128);
                    Render3DEngine.drawBoxWithParams(class_243.method_24953((class_2382)pos).method_1031(0.0, -0.5, 0.0), newBlockColor, matrices, 0.5f, 1.0f);
                }
            });
        }
        super.onWorldRender(matrices);
    }

    @Override
    public void draw(class_4587 matrices) {
        BlockESP.getLoadedChunks().forEach(chunk -> chunk.method_12214().values().forEach(blockEntity -> {
            if (this.blocksToHighlight.contains(blockEntity.method_11010().method_26204())) {
                class_2338 pos = blockEntity.method_11016();
                if (this.showNames.isEnabled()) {
                    this.drawNameTag(matrices, blockEntity.method_11010().method_26204(), pos);
                }
            }
        }));
    }

    private void drawNameTag(class_4587 matrices, class_2248 block, class_2338 blockPos) {
        class_243 screenPos = WorldUtils.worldToScreen(new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 1.5, (double)blockPos.method_10260() + 0.5));
        if (screenPos.field_1350 < 0.0 || screenPos.field_1350 > 1.0) {
            return;
        }
        int boxWidth = 20;
        int boxHeight = 20;
        Render2DEngine.drawRoundedBlur(matrices, (int)screenPos.field_1352 - boxWidth / 2, (int)screenPos.field_1351 - boxHeight / 2, boxWidth, boxHeight, 4.0f, 14.0f, 0.0f, true);
        class_1799 blockItemStack = new class_1799((class_1935)block.method_8389());
        Render2DEngine.renderItem(matrices, blockItemStack, (float)(screenPos.field_1352 - 8.0), (float)(screenPos.field_1351 - 8.0), 1.0f, true);
    }

    private void drawHighlightOutline(class_4587 matrices, class_2338 blockPos) {
        class_4184 camera = BlockESP.mc.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        double x = (double)blockPos.method_10263() - camPos.field_1352;
        double y = (double)blockPos.method_10264() - camPos.field_1351;
        double z = (double)blockPos.method_10260() - camPos.field_1350;
        class_243 position = new class_243(x, y, z);
        Color color = new Color(255, 0, 0, 89);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        Render3DEngine.drawRectangleOutline(matrices, buffer, x, y, z, this.blockColor.getColor());
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private void drawFilledBox(class_4587 matrices, class_2338 blockPos) {
        class_4184 camera = BlockESP.mc.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        double x = (double)blockPos.method_10263() - camPos.field_1352;
        double y = (double)blockPos.method_10264() - camPos.field_1351;
        double z = (double)blockPos.method_10260() - camPos.field_1350;
        class_243 position = new class_243(x, y, z);
        Color color = this.blockColor.getColor();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        Render3DEngine.drawFilledRectangle(matrices, buffer, (float)x, (float)y, (float)z, 1.0f, 1.0f, color);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public static Stream<class_2818> getLoadedChunks() {
        int radius = Math.max(2, BlockESP.mc.field_1690.method_38521()) + 3;
        int diameter = radius * 2 + 1;
        class_1923 center = BlockESP.mc.field_1724.method_31476();
        class_1923 min = new class_1923(center.field_9181 - radius, center.field_9180 - radius);
        class_1923 max = new class_1923(center.field_9181 + radius, center.field_9180 + radius);
        return Stream.iterate(min, pos -> {
            int x = pos.field_9181;
            int z = pos.field_9180;
            if (++x > max.field_9181) {
                x = min.field_9181;
                ++z;
            }
            if (z > max.field_9180) {
                throw new IllegalStateException("Stream limit didn't work.");
            }
            return new class_1923(x, z);
        }).limit(diameter * diameter).filter(c -> BlockESP.mc.field_1687.method_8393(c.field_9181, c.field_9180)).map(c -> BlockESP.mc.field_1687.method_8497(c.field_9181, c.field_9180)).filter(Objects::nonNull);
    }
}

