/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.systems.module.impl.misc;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.gui.setting.BooleanSetting;
import net.fabricmc.fabric.managers.SocialManager;
import net.fabricmc.fabric.systems.module.core.Category;
import net.fabricmc.fabric.systems.module.core.Module;
import net.fabricmc.fabric.utils.render.ColorUtil;
import net.fabricmc.fabric.utils.render.Render3DEngine;
import net.fabricmc.fabric.utils.render.RenderHelper;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_6880;

public class Resolver
extends Module {
    public static final Map<class_1657, Float> healthMap = new HashMap<class_1657, Float>();
    private final Map<class_1657, List<PositionData>> positionHistory = new HashMap<class_1657, List<PositionData>>();
    BooleanSetting resolvePos = new BooleanSetting("R".concat("#").concat("e").concat("!").concat("s").concat("-").concat("o").concat("+").concat("l").concat("-").concat("v").concat("$").concat("e").concat("_").concat(" ").concat("!").concat("P").concat(")").concat("o").concat("^").concat("s").concat("#").concat("i").concat("^").concat("t").concat("^").concat("i").concat("!").concat("o").concat("@").concat("n"), true, "R".concat("#").concat("e").concat("-").concat("s").concat("_").concat("o").concat("*").concat("l").concat("(").concat("v").concat("-").concat("e").concat("+").concat("s").concat("(").concat(" ").concat("^").concat("p").concat("-").concat("o").concat("#").concat("s").concat("$").concat("i").concat(")").concat("t").concat("#").concat("i").concat("^").concat("o").concat("$").concat("n").concat("+").concat(" ").concat(")").concat("o").concat("^").concat("f").concat("-").concat(" ").concat("&").concat("e").concat(")").concat("n").concat("(").concat("e").concat("*").concat("m").concat("-").concat("y"));
    BooleanSetting resolvePotions = new BooleanSetting("R".concat("(").concat("e").concat("_").concat("s").concat("(").concat("o").concat("!").concat("l").concat("!").concat("v").concat("#").concat("e").concat("!").concat(" ").concat("#").concat("P").concat("_").concat("o").concat("#").concat("t").concat("(").concat("i").concat("_").concat("o").concat("(").concat("n").concat(")").concat("s"), false, "S".concat("*").concat("h").concat("*").concat("o").concat("@").concat("w").concat("_").concat("s").concat("#").concat(" ").concat("&").concat("p").concat("@").concat("o").concat("_").concat("t").concat("!").concat("i").concat("@").concat("o").concat(")").concat("n").concat("(").concat("s").concat("&").concat(" ").concat("!").concat("o").concat("$").concat("f").concat("&").concat(" ").concat("@").concat("e").concat("^").concat("n").concat("*").concat("e").concat("_").concat("m").concat("_").concat("y"));

    public Resolver() {
        super("R".concat("^").concat("e").concat("^").concat("s").concat("&").concat("o").concat("(").concat("l").concat("_").concat("v").concat("@").concat("e").concat(")").concat("r"), "A".concat("+").concat("u").concat("$").concat("t").concat("-").concat("o").concat("&").concat("m").concat("*").concat("a").concat("!").concat("t").concat("#").concat("i").concat("^").concat("c").concat("^").concat("a").concat("#").concat("l").concat("!").concat("l").concat("*").concat("y").concat("*").concat(" ").concat("-").concat("r").concat("$").concat("e").concat("^").concat("s").concat("*").concat("o").concat("$").concat("l").concat("_").concat("v").concat("@").concat("e").concat("-").concat("s").concat("-").concat(" ").concat("^").concat("c").concat("^").concat("e").concat("(").concat("r").concat("-").concat("t").concat(")").concat("a").concat("(").concat("i").concat("@").concat("n").concat("$").concat(" ").concat("*").concat("s").concat(")").concat("t").concat("&").concat("u").concat("@").concat("f").concat("-").concat("f"), Category.Miscellaneous);
        this.addSettings(this.resolvePos, this.resolvePotions);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        healthMap.clear();
        this.positionHistory.clear();
    }

    @Override
    public void onTick() {
        for (class_1657 player : Resolver.mc.field_1687.method_18456()) {
            this.updatePlayerPosition(player);
        }
    }

    @Override
    public void onWorldRender(class_4587 matrices) {
        for (class_1657 player : Resolver.mc.field_1687.method_18456()) {
            PositionData predictedPos = this.predictPosition(player);
            if (this.resolvePos.isEnabled() && predictedPos != null && player != Resolver.mc.field_1724 && !SocialManager.isBot(player)) {
                class_243 pos = new class_243(predictedPos.x, predictedPos.y, predictedPos.z);
                Render3DEngine.drawBox(pos, ColorUtil.addAlpha(Color.white, 100), matrices);
            }
            if (!this.resolvePotions.isEnabled() || player == Resolver.mc.field_1724) continue;
            this.resolvePots(player, matrices);
        }
    }

    private void resolvePots(class_1657 player, class_4587 matrices) {
        class_243 pos = new class_243(player.method_23317(), player.method_23318() + (double)player.method_17682() + 0.2, player.method_23321());
        double offsetX = 0.3;
        double offsetY = 0.3;
        for (class_1293 effect : player.method_6026()) {
            class_4074 spriteManager;
            class_1058 sprite;
            class_1291 statusEffect = (class_1291)effect.method_5579();
            if (statusEffect == null || (sprite = (spriteManager = mc.method_18505()).method_18663((class_6880)statusEffect)) == null) continue;
            int x = (int)(pos.field_1352 + offsetX);
            int y = (int)(pos.field_1351 + offsetY);
            int z = (int)pos.field_1350;
            int width = 20;
            int height = 20;
            RenderHelper.getContext().method_25298(x, y, z, width, height, sprite);
            offsetX += 0.25;
        }
    }

    public PositionData predictPosition(class_1657 player) {
        List<PositionData> history = this.positionHistory.get(player);
        if (history == null || history.size() < 2) {
            return null;
        }
        PositionData last = history.get(history.size() - 1);
        PositionData secondLast = history.get(history.size() - 2);
        double deltaX = last.x - secondLast.x;
        double deltaY = last.y - secondLast.y;
        double deltaZ = last.z - secondLast.z;
        long deltaTime = last.timestamp - secondLast.timestamp;
        double predictedX = last.x + deltaX / (double)deltaTime * 180.0;
        double predictedY = last.y + deltaY / (double)deltaTime * 180.0;
        double predictedZ = last.z + deltaZ / (double)deltaTime * 180.0;
        return new PositionData(predictedX, predictedY, predictedZ, System.currentTimeMillis());
    }

    public void updatePlayerPosition(class_1657 player) {
        this.positionHistory.computeIfAbsent(player, k -> new ArrayList()).add(new PositionData(player.method_23317(), player.method_23318(), player.method_23321(), System.currentTimeMillis()));
        List<PositionData> history = this.positionHistory.get(player);
        if (history.size() > 60) {
            history.remove(0);
        }
    }

    private static class PositionData {
        public final double x;
        public final double y;
        public final double z;
        public final long timestamp;

        public PositionData(double x, double y, double z, long timestamp) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.timestamp = timestamp;
        }
    }
}

