/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.security.checks.impl;

import java.io.File;
import java.io.IOException;
import net.fabricmc.fabric.security.checks.Result;
import net.fabricmc.fabric.security.checks.SecurityCheck;

public class VMCheck
implements SecurityCheck {
    @Override
    public Result check() {
        File[] filesToCheck;
        boolean isVM = false;
        String vendor = System.getProperty("java.vendor");
        String name = System.getProperty("java.vm.name");
        String version = System.getProperty("java.vm.version");
        String classPath = System.getProperty("java.class.path");
        if (vendor != null && vendor.toLowerCase().contains("vmware")) {
            isVM = true;
        } else if (name != null && name.toLowerCase().contains("virtualbox")) {
            isVM = true;
        } else if (version != null && version.toLowerCase().contains("virtual")) {
            isVM = true;
        } else if (classPath != null && classPath.toLowerCase().contains("android")) {
            isVM = true;
        }
        for (File file : filesToCheck = new File[]{new File("C:\\WINDOWS\\system32\\drivers\\vmmouse.sys"), new File("/usr/share/virtualbox")}) {
            if (!file.exists()) continue;
            isVM = true;
            break;
        }
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            try {
                Process process = Runtime.getRuntime().exec("reg query HKLM\\HARDWARE\\ACPI\\DSDT\\VBOX__");
                process.waitFor();
                if (process.exitValue() == 0) {
                    isVM = true;
                }
            }
            catch (IOException | InterruptedException process) {
                // empty catch block
            }
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long availableMemory = maxMemory - totalMemory + freeMemory;
        if (availableProcessors <= 2 || availableMemory <= 0x20000000L) {
            isVM = true;
            System.exit(1001);
        }
        return isVM ? Result.FAIL : Result.SUCCESS;
    }
}

