/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.security.checks.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import net.fabricmc.fabric.security.checks.Result;
import net.fabricmc.fabric.security.checks.SecurityCheck;

public class DumpCheck
implements SecurityCheck {
    private static final String[] naughtyFlags = new String[]{"-XBootclasspath", "-javaagent", "-Xdebug", "-agentlib", "-Xrunjdwp", "-Xnoagent", "-verbose", "-DproxySet", "-DproxyHost", "-DproxyPort", "-Djavax.net.ssl.trustStore", "-Djavax.net.ssl.trustStorePassword"};

    @Override
    public Result check() {
        try {
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            String jvmArgs = runtimeBean.getInputArguments().toString();
            for (String arg : naughtyFlags) {
                if (!jvmArgs.contains(arg)) continue;
                return Result.FAIL;
            }
            if (DumpCheck.isClassLoaded("sun.instrument.InstrumentationImpl") || DumpCheck.isClassLoaded("java.lang.instrument.Instrumentation") || DumpCheck.isClassLoaded("java.lang.instrument.ClassFileTransformer")) {
                return Result.FAIL;
            }
            return Result.SUCCESS;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Result.FAIL;
        }
    }

    private static boolean isClassLoaded(String clazz) {
        try {
            Class<?> loadedClass = Class.forName(clazz, false, Thread.currentThread().getContextClassLoader());
            return loadedClass != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

