/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.security.checks.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import net.fabricmc.fabric.security.checks.Result;
import net.fabricmc.fabric.security.checks.SecurityCheck;

public class BlacklistCheck
implements SecurityCheck {
    String[] blacklistedNames = new String[]{"00900BC83803", "0CC47AC83803", "6C4E733F-C2D9-4", "ACEPC", "AIDANPC", "ALENMOOS-PC", "ALIONE", "APPONFLY-VPS", "ARCHIBALDPC", "azure", "B30F0242-1C6A-4", "BAROSINO-PC", "BECKER-PC", "BEE7370C-8C0C-4", "COFFEE-SHOP", "COMPNAME_4047", "d1bnJkfVlH", "DESKTOP-19OLLTD", "DESKTOP-1PYKP29", "DESKTOP-1Y2433R", "DESKTOP-4U8DTF8", "DESKTOP-54XGX6F", "DESKTOP-5OV9S0O", "DESKTOP-6AKQQAM", "DESKTOP-6BMFT65", "DESKTOP-70T5SDX", "DESKTOP-7AFSTDP", "DESKTOP-7XC6GEZ", "DESKTOP-8K9D93B", "DESKTOP-AHGXKTV", "DESKTOP-ALBERTO", "DESKTOP-B0T93D6", "DESKTOP-BGN5L8Y", "DESKTOP-BUGIO", "DESKTOP-BXJYAEC", "DESKTOP-CBGPFEE", "DESKTOP-CDQE7VN", "DESKTOP-CHAYANN", "DESKTOP-CM0DAW8", "DESKTOP-CNFVLMW", "DESKTOP-CRCCCOT", "DESKTOP-D019GDM", "DESKTOP-D4FEN3M", "DESKTOP-DE369SE", "DESKTOP-DIL6IYA", "DESKTOP-ECWZXY2", "DESKTOP-F7BGEN9", "DESKTOP-FSHHZLJ", "DESKTOP-G4CWFLF", "DESKTOP-GELATOR", "DESKTOP-GLBAZXT", "DESKTOP-GNQZM0O", "DESKTOP-GPPK5VQ", "DESKTOP-HASANLO", "DESKTOP-HQLUWFA", "DESKTOP-HSS0DJ9", "DESKTOP-IAPKN1P", "DESKTOP-IFCAQVL", "DESKTOP-ION5ZSB", "DESKTOP-JQPIFWD", "DESKTOP-KALVINO", "DESKTOP-KOKOVSK", "DESKTOP-NAKFFMT", "DESKTOP-NKP0I4P", "DESKTOP-NM1ZPLG", "DESKTOP-NTU7VUO", "DESKTOP-QUAY8GS", "DESKTOP-RCA3QWX", "DESKTOP-RHXDKWW", "DESKTOP-S1LFPHO", "DESKTOP-SUPERIO", "DESKTOP-V1L26J5", "DESKTOP-VIRENDO", "DESKTOP-VKNFFB6", "DESKTOP-VRSQLAG", "DESKTOP-VWJU7MF", "DESKTOP-VZ5ZSYI", "DESKTOP-W8JLV9V", "DESKTOP-WG3MYJS", "DESKTOP-WI8CLET", "DESKTOP-XOY7MHS", "DESKTOP-Y8ASUIL", "DESKTOP-YW9UO1H", "DESKTOP-ZJF9KAN", "DESKTOP-ZMYEHDA", "DESKTOP-ZNCAEAM", "DESKTOP-ZOJJ8KL", "DESKTOP-ZV9GVYL", "DOMIC-DESKTOP", "EA8C2E2A-D017-4", "ESPNHOOL", "GANGISTAN", "GBQHURCC", "GRAFPC", "GRXNNIIE", "gYyZc9HZCYhRLNg", "JBYQTQBO", "JERRY-TRUJILLO", "JOHN-PC", "JUDES-DOJO", "JULIA-PC", "LANTECH-LLC", "LISA-PC", "LOUISE-PC", "LUCAS-PC", "MIKE-PC", "NETTYPC", "ORELEEPC", "ORXGKKZC", "Paul Jones", "PC-DANIELE", "PROPERTY-LTD", "Q9IATRKPRH", "QarZhrdBpj", "RALPHS-PC", "SERVER-PC", "SERVER1", "Steve", "SYKGUIDE-WS17", "T00917", "test42", "TIQIYLA9TW5M", "TMKNGOMU", "TVM-PC", "VONRAHEL", "WILEYPC", "WIN-5E07COS9ALR", "WINDOWS-EEL53SN", "WINZDS-1BHRVPQU", "WINZDS-22URJIBV", "WINZDS-3FF2I9SN", "WINZDS-5J75DTHH", "WINZDS-6TUIHN7R", "WINZDS-8MAEI8E4", "WINZDS-9IO75SVG", "WINZDS-AM76HPK2", "WINZDS-B03L9CEO", "WINZDS-BMSMD8ME", "WINZDS-BUAOKGG1", "WINZDS-K7VIK4FC", "WINZDS-QNGKGN59", "WINZDS-RST0E8VU", "WINZDS-U95191IG", "WINZDS-VQH86L5D", "WORK", "XC64ZB", "XGNSVODU", "ZELJAVA", "3CECEFC83806", "C81F66C83805", "DESKTOP-USLVD7G", "DESKTOP-AUPFKSY", "DESKTOP-RP4FIBL", "DESKTOP-6UJBD2J", "DESKTOP-LTMCKLA", "DESKTOP-FLTWYYU", "DESKTOP-WA2BY3L", "DESKTOP-UBDJJ0A", "DESKTOP-KXP5YFO", "DESKTOP-DAU8GJ2", "DESKTOP-FCRB3FM", "DESKTOP-VYRNO7M", "DESKTOP-PKQNDSR", "DESKTOP-SCNDJWE", "DESKTOP-RSNLFZS", "DESKTOP-MWFRVKH", "DESKTOP-QLN2VUF", "DESKTOP-62YPFIQ", "DESKTOP-PA0FNV5", "DESKTOP-B9OARKC", "DESKTOP-J5XGGXR", "DESKTOP-JHUHOTB", "DESKTOP-64ACUCH", "DESKTOP-SUNDMI5", "DESKTOP-GCN6MIO", "FERREIRA-W10", "DESKTOP-MJC6500", "DESKTOP-WS7PPR2", "DESKTOP-XWQ5FUV", "DESKTOP-UHHSY4R", "DESKTOP-ZJRWGX5", "DESKTOP-ZYQYSRD", "WINZDS-MILOBM35", "DESKTOP-K8Y2SAM", "DESKTOP-4GCZVJU", "DESKTOP-O6FBMF7", "DESKTOP-WDT1SL6", "EIEEIFYE", "CRYPTODEV222222", "EFA0FDEC-8FA7-4", "DESKTOP-O7BI3PT", "DESKTOP-UHQW8PI", "WINZDS-PU0URPVI", "ABIGAI", "JUANYARO", "floppy", "CATWRIGHT", "WDAGUtilityAccount", "DESKTOP-3VPP8RH"};
    String[] blacklistedProcceses = new String[]{"httpdebuggerui.exe", "wireshark.exe", "fiddler.exe", "taskmgr.exe", "vboxservice.exe", "df5serv.exe", "processhacker.exe", "vboxtray.exe", "vmtoolsd.exe", "vmwaretray", "vmacthlp.exe", "vmsrvc.exe", "vmusrvc.exe", "ida64.exe", "ollydbg.exe", "pestudio.exe", "vmwareuser.exe", "vgauthservice.exe", "x96dbg.exe", "x32dbg.exe", "prl_cc.exe", "prl_tools.exe", "xenservice.exe", "qemu-ga.exe", "joeboxcontrol.exe", "ksdumperclient.exe", "ksdumper.exe", "joeboxserver.exe"};

    @Override
    public Result check() {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            return Result.FAIL;
        }
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("tasklist");
            BufferedReader reader = new BufferedReader(new InputStreamReader(processBuilder.start().getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            String processes = builder.toString();
            String host = InetAddress.getLocalHost().getHostName();
            for (String process : this.blacklistedProcceses) {
                if (!processes.contains(process)) continue;
                return Result.FAIL;
            }
            for (String name : this.blacklistedNames) {
                if (!name.equals(host)) continue;
                return Result.FAIL;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Result.SUCCESS;
    }
}

